#include "mbed.h"
#include "RangeFinder.h"
#include "VodafoneUSBModem.h"
#include "VodafoneUSBModem/Socket/UDPSocket.h"

void test(void const*) {
    set_time(0);    // really should set time over network, needed a 
                    // set_time() or time(NULL) gave -1 for some reason
    AnalogIn batterymonitor(p19);
    RangeFinder rf(p21, 10, 5800.0, 100000);
    float battery;
    int index = 0;
    float distances[100];
    time_t times[100];
    int loop = 60;
    UDPSocket sock;
    VodafoneUSBModem mo;
    while(1) {
        distances[index] = rf.read_m();
        times[index] = time(NULL);
        printf("%i: d = %f m, t = %d s.\n", index, distances[index], times[index]);
        wait(1.0);
        index++;
        if (index == loop)   {   
            index = 0;
            printf("I am attempting to connect...\n");
            int x = mo.connect("smart");
            if (x){
                printf("Failed to connect.\n");
            }   else    {
                int bound = sock.bind(87);
                printf("Bound = %d.\n", bound);
                Endpoint server;
                int servercon = server.set_address("someurl.org", 2345);
                char databuffer[512];
                for (int i = 0; i < loop; i++)    {
                    sprintf(databuffer, "id=mbedAA,time=%i,height=%f", times[i], distances[i]);
                    int len = 0;
                    for (len = 0; len < 512; len++) {
                        if (databuffer[len] == '\0')  break;
                    }
                    printf("Sending: %s (%d)\n", databuffer, len);
                    int n = sock.sendTo(server, databuffer, len);
                    printf("Sent %i bytes.\n", n);
                }
                battery = batterymonitor.read() * 3.3 * 3.0;
                printf("Battery at %f V.\n", battery);
                sprintf(databuffer, "id=mbedAA,time=%d,battery=%f", time(NULL), battery);
                int len;
                for (len = 0; len < 512; len++) {
                    if (databuffer[len] == '\0') break;
                }
                sock.sendTo(server, databuffer, len);
                mo.disconnect();
            }
        }
    }
}

int main()
{
  Thread testTask(test, NULL, osPriorityNormal, 1024 * 10);
  DigitalOut led(LED2);
  while(1)
  {
    led=!led;
    Thread::wait(10000);  
  }

  return 0;
}