#ifndef AD9249_H
#define AD9249_H
/*  interface for controlling the AD9249 ADC ,  16 channel ADC  Analog Devices

-only one CSB line , so assumes the pins CSB1 and CSB2 are connected together . 
-only MSB mode is supported,  so configuration register MSB is set at the start. 


W. Beaumont 
(C) Universiteit Antwerpen  27 August 2014 

*/ 

#define AD9249_HDR_VER  "1.22" 
#include "getVersion.h"

class SWSPI_BI;
//class DigitalIn; 

class AD9249: public getVersion {
    typedef  unsigned char u8;
    typedef  unsigned int u32;
    typedef  unsigned short u16;
// address defs     
    static const u16 configreg =            0x0;
    static const u16 chip_id_reg =          0x1;
    static const u16 chip_grade_reg =       0x2;
   // static const u16 unused_reg= { 0x3, 0x07, 0xA, 0xE, 0xF ,0x11, 0x12,0x13, 0x17, 0x1D, 0x1E, 0x1F,0x20 };
    static const u16 dev_index2_reg =       0x4;
    static const u16 dev_index1_reg =       0x4;
    static const u16 transfer_reg =         0xFF;
    static const u16 power_mode_reg =       0x8;
    static const u16 clock_gobal_reg =      0x9;
    static const u16 clock_divide_reg =     0xB;
    static const u16 enhancement_ctr_reg =  0xC;
    static const u16 test_mode_reg =        0xD;
    static const u16 offset_adj_reg =       0x10;
    static const u16 output_mode_reg =      0x14;
    static const u16 output_adj_reg =       0x15;
    static const u16 output_phase_reg =     0x16;
    static const u16 vref_reg =             0x18;
    static const u16 usserpatt1_LSB_reg =   0x19;
    static const u16 usserpatt1_MSB_reg =   0x1A;
    static const u16 usserpatt2_LSB_reg =   0x1B;
    static const u16 usserpatt2_MSB_reg =   0x1C;
    static const u16 serial_out_cntr_reg =  0x21;
    static const u16 serial_status_reg =    0x22;
    static const u16 sample_rate_reg =      0x100;
    static const u16 user_io_ctr2_reg =     0x101;
    static const u16 user_io_ctr3_reg =     0x102;
    static const u16 sync_reg =             0x109;
   
    u32 spi_cycle(u16 reg, bool rw, u16 nrbytes, u32 data);
    SWSPI_BI * spi;
    DigitalOut * csb;    
    public:
        AD9249(SWSPI_BI * spi_dev, DigitalOut * csb_dev);
        bool getDevInfo(u8& chipid, u8& grade, u16& rb);
        bool getDevId(u8& chipid);
        bool getGrade(u8& grade); 
        bool setPattern1(u16 pattern);
        bool setPattern2(u16 pattern);
        bool readPattern1(u16& pattern);
        bool readPattern2(u16& pattern);
        //general read write 
        bool setReg16(u16 regaddr, u16 data);
        bool setReg8(u16 regaddr, u8 data);
        bool readReg16(u16 regaddr, u16& data);
        bool readReg8(u16 regaddr, u8& data);   
        void init1();
        void init2();
};

#endif 