#include "adt7320.h"


#define  CS_ACTIVE 1
#define  CS_DEACTIVE 0

#define ADT7320_SRC_VER "1.13" 




adt7320::adt7320(SWSPI * spiinterface, DigitalOut * chipselect):
    getVersion(ADT7320_HDR_VER, ADT7320_SRC_VER, __TIME__, __DATE__)
{
    spi=spiinterface;
    cs=chipselect;
}

void adt7320::set_spi_mode(u8 nrbyte){
    spi->format(nrbyte,1);
    spi->frequency(10000000);             
}

u8 adt7320::format_cmd(u8 reg, bool rw){
    u8 cmd = 0;
    reg = reg & 0x7;
    cmd = reg << 3;
    if (rw) cmd |= 0x40;  // write bit 6 
    return cmd; 
}    

u8 adt7320::getR08(u8 reg) {
    set_spi_mode(16);
    u16 data = 0x00FF;
    u16 cmd = (u16) format_cmd(reg, true);
    cmd = cmd << 8;
    data = data | cmd;
    cs->write(CS_ACTIVE);
    data= spi->write(data);
    cs->write(CS_DEACTIVE);
    return (u8) (0x00FF & data);
}

void adt7320::setR08(u8 reg, u8 datain) {
    set_spi_mode(16);
    u16 data = 0x0000;
    u16 cmd = (u16) format_cmd(reg, false);
    cmd = cmd << 8;
    data = datain | cmd;
    cs->write(CS_ACTIVE);
    data = spi->write(data);
    cs->write(CS_DEACTIVE);    
}

u16 adt7320::getR16(u8 reg) {
    set_spi_mode(24);
    u32 data = 0x0000FFFF;
    u32 cmd = (u32) format_cmd(reg, true);
    cmd = cmd << 16;
    data = data | cmd;
    cs->write(CS_ACTIVE);
    data= spi->write(data);
    cs->write(CS_DEACTIVE);
    return (u16) (0x0000FFFF & data);             
}

void  adt7320::setR16(u8 reg, u16 datain) {
    set_spi_mode(24);
    u32 data = 0x00000000;
    u32 cmd = (u32) format_cmd(reg, false);
    cmd = cmd << 16;
    data = datain | cmd;
    cs->write(CS_ACTIVE);
    data = spi->write(data);
    cs->write(CS_DEACTIVE);
}

u8 adt7320::getId(){
    return getR08(0x03);
}

u16 adt7320::get_TcritSP(){
    return getR16(0x04);   
}    

void adt7320::set_TcritSP(u16 tcrit){
    setR16(0x04, tcrit);   
}    

u16 adt7320::get_T(){
    return getR16(0x02);   
}    


void adt7320::init1() {
}

void adt7320::init2() {
}