#ifndef __MCP4822_H__
#define __MCP4822_H__

#include "mbed.h"

/** MCP4822 dual 12-bit DAC
* @author NickRyder, atyeomans
* @version 1.1
* @section LICENSE
* The MIT License (MIT)
* Copyright (c) 2013 Nick Ryder, Andrew Yeomans
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights 
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
* of the Software, and to permit persons to whom the Software is furnished to do so,
*  subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all 
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

class MCP4822   {
    public:
        /** Create an MCP4822 instance
        * @param dataout SPI MOSI pin (should be p5 or p11)
        * @param clock  SPI clock pin (should be p7 or p13)
        * @param chipselect SPI chip select pin (can be any)
        * @param latch Latch pin updates the DAC out. Can be any pin or NC, if NC then the latch pin on the DAC chip should be held to GND.
        */
        MCP4822(PinName dataout, PinName clock, PinName chipselect, PinName latch);
        //! Set output A to voltage
        void setA(float voltage);
        //! Set output B to voltage
        void setB(float voltage);
        //! Set both output A to voltageA and outputB to voltageB
        void set(float voltageA, float voltageB);
        //! Latch the stored values to the output pins
        void latch();
        //! shut down output from the DAC chip
        void shutdown();
        //! shut down output form channel A
        void shutdownA();
        //! shut down output form channel B
        void shutdownB();
        //! Toggle chip select pin
        void chipSel();
    private:
        DigitalOut cs, latchpin;
        SPI spi;
        void write(bool chanB, bool gain1, unsigned int voltage, bool shutdown = false);
        void setvoltage(float voltage, bool chanB = false);
};


#endif