#ifndef __mbed_irc_handlers_h__
#define __mbed_irc_handlers_h__
#include "IrcBot.h"

///  DigitalOutHandler lets users control a DigitalOut using "WRITE <name> ON/OFF"
class DigitalOutHandler : private MessageHandler {
    public:
        /** Create a DigitalOutHandler
         * @param name Name of output used in command on IRC
         * @param pin Pin the output is connected to.
         * @param verbose Whether or not a reply is sent to IRC confirming the output state
         */
        DigitalOutHandler(char * name, PinName pin, bool verbose);
        /// Set output pin on or off, reply "SET <name> ON/OFF" if verbose.
        IrcMessage handle(IrcMessage);
    private:
        DigitalOut pin;
        char name[32];
        bool verbose;
};

///  DigitalInHandler lets users read a DigitalIn using "READ <name>"
class DigitalInHandler : private MessageHandler {
    public:
        /** Create a DigitalInHandler
         * @param name Name of input used in command on IRC
         * @param pin Pin the input is connected to.
         */
        DigitalInHandler(char * name, PinName pin);
        /// Reply "<name> IS ON/OFF"
        IrcMessage handle(IrcMessage);
    private:
        DigitalIn pin;
        char name[32];
};

///  AnalogInHandler lets users read a DigitalIn using "READ <name>"
class AnalogInHandler : private MessageHandler {
    public:
        /** Create an AnalogInHandler
         * @param name Name of input used in command on IRC
         * @param pin Pin the input is connected to.
         */
        AnalogInHandler(char * name, PinName pin);
        /** Define a scaling factor for the measured value [0.0 - 1.0]
         * @param scale The scaling factor
         * @param unit The units used in the message to IRC
         */
        void scale(float scale, char * unit);
        /// Measure input, scale and reply "<name> = <value> <units>"
        IrcMessage handle(IrcMessage);
    private:
        AnalogIn pin;
        char name[32];
        char unit[32];
        float scaleval;
};

/// A handler to echo back any messages of the form "ECHO <x>"
class EchoHandler : private MessageHandler {
    public:
        EchoHandler(){};
        /// Reply to "ECHO <x>" with "<x>"
        IrcMessage handle(IrcMessage msg);
};

#endif