#include "IrcMessageHandlers.h"

DigitalOutHandler::DigitalOutHandler(char * n, PinName p, bool v) :
    pin(p), verbose(v)
{
    sprintf(name, "%s", n);
    pin = 0;
}

IrcMessage DigitalOutHandler::handle(IrcMessage msg) {
    IrcMessage reply;
    if (verbose) {
        if (msg.to[0] == '#') {
            strcpy(reply.to, msg.to); 
        } else {
            strcpy(reply.to, msg.from);
        }
    }
    char required[64];
    sprintf(required, "WRITE %s", name);
    char * c = NULL;
    c = strstr(msg.msg, required);
    if (c != NULL) {
        c = strstr(msg.msg, "ON");
        if (c != NULL) {
            pin = 1;
            if (verbose) {
                sprintf(reply.msg, "SET %s ON", name);        
            }
        }
        c = strstr(msg.msg, "OFF");
        if (c != NULL) {
            pin = 0;
            if (verbose) {
                sprintf(reply.msg, "SET %s OFF", name);
            }
        }
    }
    return reply;
}

DigitalInHandler::DigitalInHandler(char * n, PinName p) :
    pin(p)
{
    sprintf(name, "%s", n);
}

IrcMessage DigitalInHandler::handle(IrcMessage msg) {
    IrcMessage reply;
    if (msg.to[0] == '#') {
        strcpy(reply.to, msg.to); 
    } else {
        strcpy(reply.to, msg.from);
    }
    char required[64];
    sprintf(required, "READ %s", name);
    char * c = NULL;
    c = strstr(msg.msg, required);
    if (c != NULL) {
        if (pin) {
            sprintf(reply.msg, "%s is ON", name);
        } else {
            sprintf(reply.msg, "%s is OFF", name);
        }
    }
    return reply;
}

AnalogInHandler::AnalogInHandler(char * n, PinName p) :
    pin(p), scaleval(1.0)
{
    sprintf(name, "%s", n);
    sprintf(unit, "");
}

void AnalogInHandler::scale(float s, char * u) {
    scaleval = s;
    sprintf(unit, "%s", u);
}

IrcMessage AnalogInHandler::handle(IrcMessage msg) {
    IrcMessage reply;
    if (msg.to[0] == '#') {
        strcpy(reply.to, msg.to); 
    } else {
        strcpy(reply.to, msg.from);
    }
    char required[64];
    sprintf(required, "READ %s", name);
    char * c = NULL;
    c = strstr(msg.msg, required);
    if (c != NULL) {
        float v = pin * scaleval;
        sprintf(reply.msg, "%s = %f %s", name, v, unit);
    }
    return reply;
}

IrcMessage EchoHandler::handle(IrcMessage msg) {
    IrcMessage reply;
    char * c = NULL;
    c = strstr(msg.msg, "ECHO ");
    if (c != NULL) {
        strcpy(reply.from, msg.to);
        if (msg.to[0] == '#') {
            strcpy(reply.to, msg.to);
        } else {
            strcpy(reply.to, msg.from);
        }
        strcpy(reply.msg, c + 5);
    }        
    return reply;
}
