#include "mbed.h"
//#include "Websocket.h"
#include "SDFileSystem.h"
#include "SiPM.h"
#include <vector>

//Websocket ws("ws://sockets.mbed.org/ws/NickRyder/wo");
char url[100] = "ws://pplxgo1.physics.ox.ac.uk:8008/log";
//char url[100] = "ws://163.1.136.220:8008/log";
//char url[100] = "ws://sockets.mbed.org:80/ws/NickRyder/wo";
//Websocket ws(url);

SDFileSystem sd(p5, p6, p7, p8, "sd");

DigitalOut myled(LED1);
DigitalOut webconnected(LED4);
AnalogOut comparison(p18);
AnalogIn temperature(p15);
AnalogIn bias(p20);
Serial pc(USBTX, USBRX);
float scantime;
unsigned long n;

SiPM sipm1(p21, LED2);
//SiPM sipm2(p22, LED3);

void scan(float voltage, float waittime) {
    float scale = voltage / 3.3;
    comparison.write(scale);
    sipm1.reset();
//    sipm2.reset();
    wait(waittime);
    sipm1.stop();
//    sipm2.stop();
}

int main() {
    pc.printf("# Connecting together sipms.\n");
//    sipm1.addother(&sipm2);
//    sipm2.addother(&sipm1);
    pc.printf("# Done.\n");
    webconnected = 0;
    pc.printf("# Started.\n");
    time_t now = time(NULL);
    pc.printf("# Time is now %d\n", now);
    /*
      pc.printf("# Trying to set time...\n");
        int n = 0;
        char timeword[20];
        int j = 0;
        for (int i = 0; i < 20; i++) {
            if (pc.readable()) {
                while (pc.readable()) {
                    timeword[j] = pc.getc();
                    j += 1;
                    wait(0.1);
                }
            }
            wait(0.5);
        }
        timeword[j] = 0;
        n = atoi(timeword);
        pc.printf("# n = %d\n", n);
        if (n > 10000)  {
            set_time(n);
            now = time(NULL);         
            pc.printf("# Set time to %s", ctime(&now));
        } else  {
            pc.printf("# Failed to set time.\n");
        }
    }
    */
    myled = 1;
    scantime = 20.0;
    pc.printf("# Each scan is %f seconds.\n", scantime);
    vector<float> vscan;
//    vscan.push_back(0.05);
//    vscan.push_back(0.10);
//    vscan.push_back(0.15);
//    vscan.push_back(0.20);
//    vscan.push_back(0.25);
//    vscan.push_back(0.30);
//    vscan.push_back(0.35);
//    vscan.push_back(0.40);
//    vscan.push_back(0.45);
    vscan.push_back(0.50);
//    vscan.push_back(0.55);
    vscan.push_back(0.60);
//    vscan.push_back(0.65);
    vscan.push_back(0.70);
//    vscan.push_back(0.75);
    vscan.push_back(0.80);
//    vscan.push_back(0.85);
    vscan.push_back(0.90);
//    vscan.push_back(0.95);
    vscan.push_back(1.00);
    vscan.push_back(1.10);
    vscan.push_back(1.20);
    vscan.push_back(1.30);
    vscan.push_back(1.40);
    vscan.push_back(1.50);
    vscan.push_back(1.60);
//   vscan.push_back(1.70);
//    vscan.push_back(1.80);
//    vscan.push_back(1.90);
//    vscan.push_back(2.00);
//    vscan.push_back(2.20);
//    vscan.push_back(2.50);
//    vscan.push_back(2.75);
    //vscan.push_back(3.00);
    vector<float>::iterator vit;
    int loop = 0;
    char msg[200];
    while (true) {
        pc.printf("# Starting loop %d.\n", loop);
        loop++;
        FILE * outp = NULL;
        for (vit = vscan.begin() ; vit != vscan.end(); vit++)   {
            float v = *vit;
            time_t start = time(NULL);
            pc.printf("# %f V started at %s", v, ctime(&start));
            scan(v, scantime);
            sprintf(msg, "%f, %f, %i, %i, %i, %s", 
                    scantime, v,
                    sipm1.n, sipm1.ncoincidence, sipm1.ntrig,
                    ctime(&start));
            outp = fopen("/sd/sipm.dat", "a");
            fprintf(outp, "%s", msg);
            fclose(outp);
            pc.printf(msg);
        }
    }
}