#include "SiPM.h"

SiPM::SiPM(PinName pin, PinName led) : 
        n(0), ncoincidence(0), ntrig(0),
        time(),
        checkcoincidence(false), running(false),
        interval(20), deadtime(50),
        other(NULL),
        iin(pin), ledpin(led)
        {
    iin.rise(this, &SiPM::trigger);
    ledpin = 1;
}

void SiPM::addother(SiPM * sipm) {
   other = sipm;
   checkcoincidence = true;
}

void SiPM::setinterval_us(int t)  {
    interval = t;
}

void SiPM::setdeadtime_us(int t)  {
    deadtime = t;
}

void SiPM::trigger()    {
    ntrig++;
    if (running) {
        ledpin = !ledpin;
        if (time.read_us() > deadtime)  {
            n++;
            time.reset();
            if (checkcoincidence)   {
                if (other->time.read_us() < interval)   {
                    ncoincidence++;
                }
            }        
        }
    }
}

void SiPM::reset()  {
    n = 0;
    ncoincidence = 0;
    ntrig = 0;
    start();
}

void SiPM::start()  {
    running = true;
    time.start();
    printf("# Starting SiPM.\n");
}

void SiPM::stop()   {
    running = false;
    printf("#Stopping SiPM.\n");
}