#ifndef AD5384_H
#define AD5384_H

#include "solid_sctrl_def.h"
#include "SWSPI.h"
#include "getVersion.h"

#define VERSION_AD5384_HDR "1.12"


/*
 * class to set and readback the AD5384
 * to minimize the access to the device there is a shadow of the DAC, GAIN and OFFSET values 
    
 * v0.10  initial development to see if reading / writing is possible    
 * v1.10  initial  release versioni
 * v1.11  added init1 init2
*/ 
class SWSPI;
#include "mbed.h"
//class DigitalOut;

class AD5384 : public getVersion {
    SWSPI *spi;
    DigitalOut * cs; 
    float vref;
    
    void set_spi_mode();
    u16 calculate_dac_setting(u8 nr, float vout);
    u32 format_word(u8 mode, u8 ch, u8 rw, u16 data);
    u16 get_reg(u8 mode, u8 ch);
    u32  set_reg(u8 mode, u8 ch, u16 value);
    public: 
        AD5384(SWSPI * spiinterface, DigitalOut * chipselect);
        
        u16 dac[40];
        u16 gain[40];
        u16 offset[40];
        float volt[40];
        u16 get_dac(u8 ch);
        u16 set_dac(u8 ch, u16 dac);
        u16 get_ch_out_reg(u8 ch) ;
        u16 set_volt(u8 nr, float vout);
        u16 set_gain(u8 ch, u16 gain);
        u16 get_gain(u8 ch);
        u16 set_offset(u8 ch, u16 gain);
        u16 get_offset(u8 ch);
        // ctnrls
        u32 get_ctrl();
        u32 soft_clr();
        u32 soft_rst();
        u32 clear_code();
        void init1();
        void init2();
};

#endif 