#include "mbed.h"
#include "const.h"
#include "Robot.h"

Robot bertl;

void Bewegen()
{
    bertl.move();    
}

void DrehLinks()
{
    bertl.TurnLeft();
}

void ViererKette(int value)
{
    bertl.NibbleLeds(value);
}

void SchalteLedEin(int16_t led)
{
    bertl.TurnLedOn(led);
}

void SchalteLedAus(int16_t led)
{
    bertl.TurnLedOff(led);
}

void RotGruenBlauLed(bool red, bool green, bool blue)
{
    bertl.RGBLed(red, green, blue);    
}

void BlaueLedAus()
{
    bertl.BlueLedsOFF();    
}

void BlaueLedAn()
{
    bertl.BlueLedsON();    
}

bool WarteBisButtonGedruecktWird()
{
    if(bertl.WaitUntilButtonPressed())
    {
        return true;
    } else {
        return false;
    }
}

bool VorneFrei()
{
    if(bertl.FrontIsClear())
    {
        return true;
    } else {
        return false;
    }
}

bool NacheVonStreifen()
{
    if(bertl.NextToABeeper())
    {
        return true;
    } else {
        return false;
    }
}

bool IstKnopfGedrueckt(const int btn)
{
    if(bertl.IsButtonPressed(btn))
    {
        return true;
    } else {
        return false;
    }
}

int ZurueckZuKnopfGedrueckt()
{
    if(bertl.ReturnButtonPressed())
    {
        return true;
    } else {
        return false;
    }
}

int main()
{
    
}



 



 
