/** Spaceship Class
* @brief It manages data relevant to spaceships in the game
* @author Nicholas Wu
* @date May, 2020
*/
#ifndef SPACESHIP_H
#define SPACESHIP_H
#include "mbed.h"

class Spaceship{
    private:
        float v_x, v_y, acceleration, top_speed, turn_rate;
        int chamber, reload_timer;
        
        // Below five: manage direction and velocity
        void turn_CW();
        void turn_CCW();
        void accelerate();
        void deccelerate();
        void update_position();
        
        /** Controls import parameters from main
        * @param x and y (float) from left joystick
        * @returns void but writes to bullets[][]
        */
        void machine_gun(float x, float y);
        
        void cannon();
        void update_bullets();
        
    public:
        float orientation, bullet[5][4], pos_x, pos_y;
        int HP, gun_FX, explosion_FX;
        // gun_FX and explosion_FX manages sound
        
        /** Constructor
        * @param pos_x and pos_y (float) are set to an arbitrary value
        */
        Spaceship(){
            pos_x = 100;
            pos_y = 100;
        }

        /** Destructor
        * @param pos_x and pos_y (float) are set to an arbitrary value
        */
        ~Spaceship(){
            pos_x = 0;
            pos_y = 0;
        }
        
        /** controls import from main
        * @param Y, A, X, B (bool) from buttons,
        * @param x and y (float) from left joystick.
        * interacts with private control functions
        */
        void controls(bool player_ship_type,
            bool Y, bool A, bool X,
            bool B, float x, float y);
        
        /** locally directs AI ship to designated target
        * @param target_x and target_y (float) for player's position
        * @param target_orientation for player's direction
        */
        void AI_controls(float target_x, float target_y,
            float target_orientation);
        
        /** used to set parameters relevent to gameplay
        * @param x, y and direction (float) concerns position
        * @param turn, acc and top (float) denotes turn rate, acceleration and top speed
        * @param health (int) sets maximum hitpoints
        */
        void init_ship(float x, float y, float direction,
            float turn, float acc, float top, int health);
            
        /** for rendering particles (bullets) of a specific ship
        * @param temp1, temp2 (int) represents a position on the map
        * @return 1 if the area contains a bullet
        */
        bool check_bullets(int temp1, int temp2);
        
        /** for discovering presence of a spaceship's bullets in an area
        * @param target_x, target_y (float) for centre position
        * @param radius (int) for target area radius
        * @return 1 on an effective hit
        */
        bool check_hitbox(int target_x, int target_y, int radius);
        
        /** public function used to call update_bullets and update_position
        */
        void update();
};

#endif