#include "mbed.h"
#include "m3pi.h"
#include "MSCFileSystem.h"

DigitalOut myled(LED1);
m3pi m3pi;
MSCFileSystem msc("usb");

//The m3pi can have a maximum of 8 charicters on a row of it's display, so logically that is all we need to accomedate
char YourText[8];

int main() {
    //set the file you want to open to /usb/YourFile.txt and we want to read it, so fopen needs 'r'
    FILE *YourFile = fopen("/usb/YourFile.txt", "r");
    if (YourFile == NULL) {
        //if your file isnt there, turn an led on and do nothing else
        myled = 1;
        while (1) {}
    }
    //scan untill you hit then end of the document and put everything in YourText as a string
    while (!feof(YourFile)) {
        fscanf (YourFile, "%s", YourText);
    }
    m3pi.cls();
    //and print your message!
    m3pi.printf("%s", YourText);
}