#include "mbed.h"
#include "m3pi.h"
#include "MSCFileSystem.h"

DigitalOut ledone(LED1);
DigitalOut ledtwo(LED2);
DigitalOut ledthree(LED3);
DigitalOut ledfour(LED4);
MSCFileSystem msc("msc");   // allows read/write to a removable USB device through the m3pi's USB interface
Serial pc(USBTX, USBRX);
m3pi m3pi;

float speed_max;            //the maximum speed allowed. used in fwd/bck under recognition
float speed_mod;            //the modifiable speed varible used for cornering. may be used to adjust cornering values in future versions
float speed_user;

char Buffer[512];   //will house all of the data in the Commands.txt file. has space for 510 commands + one speed variable at begining (M5)

FILE *CMD = fopen("/msc/Commands.txt", "r");    //where all the commands should be stored

//this will be run in the event that something goes wrong like a character cant be recognised or a file is missing
void ERR() {
    while (1) {
        ledtwo = 0;
        ledthree = 0;
        ledone = 1;
        ledfour = 1;
        wait(0.2);
        ledfour = 0;
        ledone = 0;
        ledtwo = 1;
        ledthree = 1;
        wait(0.2);
    }
}

//run on completion of the scrip
void FIN() {
    while (1) {
        ledone = 1;
        ledtwo = 1;
        ledthree = 1;
        ledfour = 1;
        wait(0.5);
        ledone = 0;
        ledtwo = 0;
        ledthree = 0;
        ledfour = 0;
        wait(0.5);
    }
}
//this will check that all the files are present and accounted for.
void opening() {
    m3pi.cls();
    m3pi.locate(0,0);
    m3pi.printf("  LOGO");
    m3pi.locate(0,1);
    m3pi.printf("  RACE");
    FILE *CMD = fopen("/msc/Commands.txt", "r");
    //if it isnt is there, we have an ERROR, Run ERR();
    if (CMD == NULL) {
        m3pi.cls();
        m3pi.printf("CMD ERR");
        fclose(CMD);
        while (1) {
            ERR();
        }
        fclose(CMD);
    }
}

//getting everything from the text document
void grabbing() {
    fopen("/msc/Commands.txt", "r");
    while (!feof(CMD)) {
        ledone = 1;
        //put everything in Buffer as a string it would be easier to have it in seperate containers but for simplicity to understand for nivices like my, i have done it like this.
        fscanf (CMD, "%s", Buffer);
    }
    fclose(CMD);
    ledone = 0;
    //add on to the end of Buffer a *  so that the end can be recognised
    sprintf(Buffer + strlen(Buffer), "*");
}

//sets the speed
void variables () {
    if (Buffer[0] == 'M') {
        //as everything is in a string, numbers /begin at 48 (0, 1 etc) so anything after 48 should be a number
        if (Buffer[1] >= 49) {
            speed_max = ((Buffer[1] - 48) / 10);
        } else {
            // if it isnt a number, it can be used, say ERR
            m3pi.cls();
            m3pi.printf("BAD");
            m3pi.locate(0,1);
            m3pi.printf("SPEED");
            ERR();
        }
        speed_user = speed_max;
    } else {
        //if nothing is there, there has been no speed defined!
        m3pi.cls();
        m3pi.printf("NO SPEED");
        m3pi.locate(0,1);
        m3pi.printf("DEFINED");
    }
}


void recognition() {
    //this shall be used to incriment what character we are looking at
    int N=2;
    //repeat until the end of the document
    while (!feof(CMD)) {
        if (Buffer[N] == 'F' || Buffer[N] == 'f') {
            N++;
            //Because it's a  string, the conversion will turn the number 1 into 49, as it is the 49th character that can be recognised.
            while (Buffer[N] >= 48) {
                m3pi.cls();
                m3pi.printf("FWD %c", Buffer[N]);   // F represents forward and
                m3pi.forward(speed_max);            // a number after it represents how long
                wait(Buffer[N] - 48);               //to go forwards for. this senario
                m3pi.stop();                        //only includes the posibilty of
                N++;                                // a one digit number.
            }
        } else if (Buffer[N] == 'B' || Buffer[N] == 'b') {
            N++;
            while (Buffer[N] >= 48) {
                m3pi.cls();
                m3pi.printf("BACK %c", Buffer[N]);
                m3pi.backward(speed_max);
                wait(Buffer[N] - 48);
                N++;
            }
        } else if (Buffer[N] == 'R' || Buffer[N] == 'r') {
            N++;
            while (Buffer[N] >= 48) {
                int A=Buffer[N] - 48;
                m3pi.cls();
                m3pi.printf("RGHT %d", A);
                m3pi.left( - speed_max);
                m3pi.right(speed_max);
                wait(((speed_mod * 0.28)/9)*A); //a number after R or L represents
                m3pi.stop();                    //how much to turn. the algorithm
                N++;                            //above converts that to wait times for motors
            }
        } else if (Buffer[N] == 'L' || Buffer[N] == 'l') {
            N++;
            while (Buffer[N] >= 48) {
                int A=Buffer[N] - 48;
                m3pi.cls();
                m3pi.printf("LFT %d", A);
                m3pi.right( - speed_max);
                m3pi.left(speed_max);
                wait(((speed_mod * 0.28)/9)*A);
                m3pi.stop();
                N++;
            }
        } else if (Buffer[N] == 'S' || Buffer[N] == 's') {
            m3pi.cls();
            m3pi.printf("STOP");
            m3pi.stop();
            FIN();
            N++;
            //if there is a * then we have reached the end of what is in Buffer
        } else if (Buffer[N] == '*') {
            m3pi.stop();
            m3pi.cls();
            m3pi.printf("FIN!");
            FIN();
            //if there is a character that is not listed above, it is probebly an error
        } else {
            m3pi.stop();
            m3pi.cls();
            m3pi.printf("  ERR  ");
            ERR();
        }
    }
}

int main() {
    opening();
    grabbing();
    variables();
    speed_mod = speed_max;
    wait(2.0);
    recognition();
}