#include "mbed.h"
#include "HCSR04.h"

#define velocidade(a, b)    MDPWM = a; MEPWM = b 
#define sentido(a, b)       MDdirect = a; MEdirect = b

//DigitalOut myled(LED1);

Serial pc(USBTX,USBRX);     
HCSR04 sonarF(D13, D12);

DigitalOut MEdirect(D4);    //Motor 2 Direction control
DigitalOut MDdirect(D7);    //Motor 1 Direction control
PwmOut MEPWM(D5);           //Motor 2 PWM control
PwmOut MDPWM(D6);           //Motor 1 PWM control

float intA = 0.0;                         //Valor da ação de controle integral no instante anterior
float 
    tIni,
    tFin,
    T = 0.1;                //Tempo de amostragem  
float 
    SP = 25.0,             //SetPoint = 25 cm
    v,                      //Variável de controle, velocidade
    VM;                     //Variável controlada, distância
float 
    Kp = 0.03, 
    Ki = 0.02, 
    Kd = 0.005;             //Ganho de cada ação de controle
float
    aProp, 
    aDeri, 
    aInt;                   //Valor de cada ação de controle   
float 
    e, 
    eA = 0.0;               //erro do sistema                              

int main() {
    wait(1.0);
    velocidade(0.4, 0.4);
    while(1){
        VM = sonarF.getCm();
        printf("%1.2f\n", VM);
        e = SP - VM;
        
        aProp = Kp * e;
        aInt = intA + Ki * (T * ((eA + e)/ 2.0));   
        aDeri = Kd * ((e - eA)/T);
        
        eA = e;
        intA = aInt;
        
        v = aProp + aInt + aDeri;
              
        if(e <= 0){
            velocidade(v*(-1), v*(-1));
            sentido(1, 1);
        }
        else{
            velocidade(v, v);
            sentido(0, 0);
        }
        wait(T);
    }
}
