/**
@file Button.cpp
@brief main file for the Ultrasound Distance Sensor Project.
@brief Has three main functions; parking distance guide, ultrasound radar and settings.
@brief Revision 3.6.
@author Nestor Isaac Garcia Rueda (200798965)
@date 02/May/2015
*/

/*Here, we are including the following libraries and its respectively codes*/
#include "mbed.h"                                     /*Importing the mbed.h library header file of the mbed NXP LPC 1768 Microcontroller*/
#include "N5110.h"                                   /*Importing the N5110.h library header file of the Nokia 5110 LCD screen*/
#include "SRF02.h"                                  /*Importing the SRF02.h library header file of the SRF02 ultrasound device*/
#include "beep.h"                                  /*Importing beep.h library header file of the beep library*/   
#include "PowerControl/PowerControl.h"            /*Importing the PowerControl/PowerControl.h library header file of the PowerControl library*/
#include "PowerControl/EthernetPowerControl.h"   /*Importing the PowerControl/EthernetPowerControl.h library header file of the PowerControl library*/

AnalogIn pot(p20);                             /*Declaring name space (pot) and pin number (p20) of the potentiometer*/
Beep buzzer(p21);                               /*Declaring name space (buzzer) and pin number (p21) of the buzzer speaker*/
InterruptIn button(p18);                         /*Declaring name space (button) and pin number (p18) of the interrupt button*/
BusOut inLeds(LED3,LED4);                         /*Declaring name space (inLeds) and inner embedded LEDs of mbed NXP LPC 1768 Microcontroller*/

//Serial serial(USBTX,USBRX);                        /*Declaration of serial interface for CoolTerm debugging with usb transmitter and receiver defintitions*/

BusOut pcbLEDS (p25,p24,p23,p22);                      /*Declaring name space (pcbLEDS) and its corresponding pin numbers (p25,p24,p23,p22) of the LEDs of the PCB*/
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);                  /*Declaring name space (lcd) and corresponding pin numbers (p7,p8,p9,p10,p11,p13,p26) of the Nokia 5110 LCD screen*/
SRF02 srf02(p28,p27);                                /*Declaring SDA and SCL pins (p28,p27)*/

Ticker onBoardLedTimer;                           /*Ticker object for blinking on board LED*/
Ticker refLed;                                  /*Ticker object to eliminate the need for wait() function for the on-PCB status LED's*/
Ticker clearTimer;

int c = 1;                                        /*Float is 0.something and 'int' represents whole numbers, where we are declaring 'c' to be a whole number and to have a value of 1*/
void ledFlow()                                   /*Void function for executing the brightness backlight pre-intro presentation*/
{
    pcbLEDS = 8;                               /*The named space previously defined, lights on, in this case 2^3= 8 in binary, therefore it only will the fourth led*/
    wait_ms(200);                              /*Waiting time delay of 0.2 seconds*/
    pcbLEDS = 12;                              /*Lights on, in this case 2^3+2^2= 12 in binary, therefore it will only the third and fourth led*/
    wait_ms(200);                              /*Delay of 0.2 seconds*/
    pcbLEDS = 14;                              /*Lights on, in this case 2^3+2^2+2^1= 14 in binary, therefore it will only the second, third and fourth led*/
    wait_ms(200);                              /*Delay of 0.2 seconds*/
    pcbLEDS = 15;                              /*Lights on, in this case 2^3+2^2+2^1+2^0= 15 in binary, therefore it will all the four leds*/
    wait_ms(200);                              /*Delay of 0.2 seconds*/
    pcbLEDS = 0;                               /*Lights off all leds*/
    
}

float d = 1;            /* Float is 0.smth and int whole*/
void ledLaserA()         /* Void function named ledLaserA for executing the code below to be able to be called and run, executing the different led states*/
{
    pcbLEDS = 1;         /*The named space previously defined, lights on, in this case 2^0= 1 in binary, therefore it only will the first led*/
    wait_ms(110);        /*Delay of 0.11 seconds*/
    pcbLEDS = 3;;        /*Lights on, in this case 2^1+2^0= 3 in binary, therefore it only will the first and second leds*/
    wait_ms(90);         /*Delay of 0.09 seconds*/
    pcbLEDS = 7;;        /*Lights on, in this case 2^2+2^1+2^0= 7 in binary, therefore it only will the first, second and third leds*/
    wait_ms(90);         /*Delay of 0.09 seconds*/
    pcbLEDS = 15;        /*Lights on, in this case 2^3+2^2+2^1+2^0= 15 in binary, therefore it will then the first, second, third and fourth leds*/
    wait_ms(90);         /*Delay of 0.09 seconds*/                 
}
void ledLaserB()         /*void function for ledLaserB led flashing states*/
{
    pcbLEDS = 8;         /*The named space previously defined, lights on, in this case 2^3= 8 in binary, therefore it only will the fourth led*/
    wait_ms(110);        /*Delay of 0.11 seconds*/
    pcbLEDS = 12;        /*Lights on, in this case 2^3+2^2= 12 in binary, therefore it will only the third and fourth led*/
    wait_ms(90);         /*Delay of 0.09 seconds*/
    pcbLEDS = 14;        /*Lights on, in this case 2^3+2^2+2^1= 14 in binary, therefore it will only the second, third and fourth led*/
    wait_ms(90);         /*Delay of 0.09 seconds*/
    pcbLEDS = 15;        /*Lights on, in this case 2^3+2^2+2^1+2^0= 15 in binary, therefore it will all the four leds*/
    wait_ms(90);         /*Delay of 0.09 seconds*/
    pcbLEDS = 0;         /*Lights off all leds*/
}

int buttonFlag = 0;              /*between variable = 0 and variableReading = 0.3*/
int buttonAltFlag = 0;            /*Alternate flag between variable = 0.3 and variableReading = 0.6*/
int buttonSecondAltFlag = 0;        /*Second Alternate flag beyond variable = 0*/

float variableReading = pot.read();      /*fetches potentiometer reading between 0 and 1 and stores it in a variable, potReading*/

void action() //Interrupt Service Routine for Button
{
    if(variableReading <= 0.3) { //less than this pot ratio
        buttonFlag = !buttonFlag; //if flag = 0 set it to 1; otherwise reset it to 0.
    }

    else if(variableReading > 0.3 & variableReading < 0.6) { //if otherwise pot reading between this pot ratio range - radar
        buttonAltFlag = !buttonAltFlag; //if flag = 0 set it to 1; otherwise reset it to 0.
    }

    else if(variableReading >= 0.6) { //or else this pot ratio is exceeded
        //lcd.setBrightness(pot.read());
        buttonSecondAltFlag = !buttonSecondAltFlag;
        // lcd.setBrightness(pot.read());

    }

    if ( variableReading < 0.6 && buttonSecondAltFlag == 1) {
        buttonSecondAltFlag = !buttonSecondAltFlag;
        //  lcd.setBrightness(pot.read());
    }

}

int LedFlag = 0; //flag set to change on-board LED state

void LedTimerSet()  //Interrupt Service Routine for LedTimer
{
    LedFlag = 1;  //set flag when timer expires.
}

int refLedFlag = 0;

void refLedFlipped()
{
    refLedFlag = 1;
}

int clearFlag = 0;

void clearTimeout()
{
    clearFlag = 1;
}

bool state;

float a= 0.0;                    /*Floating data integer type constant defined as "a" and given the value of 0.0*/
int counter = 0;                  /*Integer r set as an integer of 0*/
void increaseBrightness()         /*void function for executing the brightness backlight pre-intro presentation*/
{
    a+=0.2;                       /*increases by 0.2 the 'a' constant*/
    lcd.setBrightness(a);         /*the lcd brightness is been set, with the pre-set and defined constant ''a'', as the initial value state*/
    wait_ms(150);                 /*Delay of 0.15 seconds*/
}

void preIntro ()             /*void function for preIntro that performs the counting, increment and reset of the constant "a" state depending on its floating value, taking into account the task of counting floating numbers*/
{

    while(counter < 2) {          /*A while loop that when the counter reaches 2, stops executing*/


        increaseBrightness();      /*calls the function*/
        if (a>0.4 && a<0.7) {
            lcd.inverseMode();    /*White and black pixels get inversed*/
        }

        else if (a>=1)  {         /*so i} the constant 'a' gets higher or equal to 1, after increasing by 0.2 every time, will execute the code line below*/
            a = 0;
            counter++;    /*sets the constant 'a' value to 0 and adds 1 to the counter when the if statement is met*/

        } else  {                /*Else statement*/
            lcd.normalMode();     /*Calls the member function normal mode running the code*/
        }
    }
}

void superIntro()
{
    
//LCD DISPLAY

    ledFlow();                                /*calls the ledFlow function been declared above*/
    lcd.clear();                              /*Clears screen by running the member function clear of the class lcd*/
    lcd.refresh();                            /*Refreshes screen by runnig member function*/
    pcbLEDS = 0;                              /*Lights off all leds*/
    lcd.printString("Electronic",15,0);         /*Calls the member function printString running the code and allowing us to print what's between quotation marks and the coordinates Y,X axis of 15 and 0*/
    lcd.printString("&",40,1);                  /*Prints on the lcd screen only the symbol "&" between quotation marks on the 40,1 Y,X axis coordinates*/
    lcd.printString("Electrical",6,2);          /*Prints "Electrical" on the 6,2 X,Y axis coordinates of the LCD*/
    lcd.printString("Engineer",37,3);           /*Prints "Engineer" on the 37,3 X,Y axis coordinates of the LCD*/
    lcd.printString("PRESENTS",5,4);            /*Prints "PRESENTS" on the 5,4 X,Y axis coordinates of the LCD*/
    lcd.printString("///*///*///*//",0,5);      /*Prints "///*///*///*//" on the 0,5 X,Y axis coordinates of the LCD*/
    wait(2);                                  /*Delay of 2 secs*/


    ledFlow();                             /*calls the ledFlow function been declared above*/
    lcd.clear();                              /*Clears screen by running the member function clear of the class lcd*/
    lcd.printString("///*///*///*//",0,0);      /*Prints "///*///*///*//" on the 0,0 X,Y axis coordinates of the LCD*/
    lcd.printString("The",34,1);                /*Prints "The" on the 34,1 X,Y axis coordinates of the LCD*/
    lcd.printString("SRF",34,2);                /*Prints "SRF" on the 34,2 X,Y axis coordinates of the LCD*/
    lcd.printString("Ultrasound",13,3);         /*Prints "Ultrasound" on the 13,3 X,Y axis coordinates of the LCD*/
    lcd.printString("Project",21,4);            /*Prints "Project" on the 21,4 X,Y axis coordinates of the LCD*/
    lcd.printString("///*///*///*//",0,5);      /*Prints "///*///*///*//" on the 0,5 X,Y axis coordinates of the LCD*/
    lcd.inverseMode();                        /*calls the function from the N5110.h library and runs the function inverseMode to inverse the B&W pixel states*/
    wait(2);                       /*waiting time of 2secs*/

    ledFlow();                      /*calls the ledFlow function been declared above*/
    lcd.clear();                           /*clears screen*/
    lcd.printString("///*///*///*//",0,0);      /*Prints "///*///*///*//" on the 0,0 X,Y axis coordinates of the LCD*/
    lcd.printString("Designed",15,1);           /*Prints "Designed" on the 15,1 X,Y axis coordinates of the LCD*/
    lcd.printString("By",34,2);                 /*Prints "By" on the 34,2 X,Y axis coordinates of the LCD*/
    lcd.printString("Nestor Isaac",7,3);        /*Prints "Nestor Isaac" on the 7,3 X,Y axis coordinates of the LCD*/
    lcd.printString("Garcia Rueda",7,4);        /*Prints "Garcia Rueda" on the 7,4 X,Y axis coordinates of the LCD*/
    lcd.printString("///*///*///*//",0,5);      /*Prints "///*///*///*//" on the 0,5 X,Y axis coordinates of the LCD*/
    lcd.normalMode();                       /*calls the function from the N5110.h library and runs the function normalMode to normal the B&W pixel states*/
    wait(3);                         /*waiting time of 3secs*/
    pcbLEDS=15;                      /*Lights on, in this case 2^3+2^2+2^1+2^0= 15 in binary, therefore it will all the four leds*/
    lcd.refresh();                      /*refreshes screen by running the corresponding member function*/
    lcd.clear();                      /*clears screen by running the corresponding member function inside the lcd class*/
}

int main ()                   /*Starts the main function where "int" represents the data type of the return value from the pgoramme where if returned a 0, means that its worked ok and if returned 1, would mean that something went wrong*/ 
{                              /*Curly bracket that reresets the openning/begining of the main function*/
    PHY_PowerDown();            /*Ethernet Power-Down, saves up around 175mW*/
    lcd.init();                 /*Initialises screen by running the member function init of the class lcd*/
    preIntro();                 /*Calls the defined void function "preIntro" declared above*/ 
    superIntro();               /*Calls the defined void function "preIntro" declared above*/
    button.rise(&action);

    onBoardLedTimer.attach(&LedTimerSet,1.0);      /*call ISR every second second*/

    refLed.attach(&refLedFlipped,0.3);             /*call ISR once after 0.3 seconds elapse*/
  
    clearTimer.attach(&clearTimeout,0.25);         /* calls ISR every quarter of a second*/

    while(1) {                                     /*Initialises a while loop that loops reading code forever*/

        if(clearFlag) {                         /*If statement that only executing if the clearFlag statement is met and runs the inner statement of "if"*/
        
                lcd.clear();                         /*clears screen by running the corresponding member function inside the lcd class*/
                clearFlag = 0;                        /*Makes the clearFlag value to be set initially as 0*/
                variableReading = pot.read();          /*Here, we are just saying that the declared floating declaration variableReading is equals to pot.read(), which reads the potentiometer resistance*/ 
                /*serial.printf("variable reading is %d\n",state);*/      /*This code was additionally used as for debugging purposes using CoolTerm so we could print ht ereadings when connecting our mbed platform to the programme*/
                lcd.drawRect(15,5,60,10,0);              /* filled black rectangle   Y,X,length, width,1=FILLIN/0=NON-FILLING*/
                lcd.drawRect(15,20,60,10,0);             /* filled black rectangle   Y,X,length, width,1=FILLIN/0=NON-FILLING*/
                lcd.drawRect(15,35,60,10,0);             /* filled black rectangle   Y,X,length, width,1=FILLIN/0=NON-FILLING*/

                lcd.drawCircle(WIDTH/11,HEIGHT/5.2,5,0);        /*Here, it takes the declared WIDTH on the lcd library of 84 pixels(in this case divided by 11) on the x axis and HEIGHT of 48 pixels in the y axis (in this case divided by 5.2),with a radius of 5cm,and 0 fo an white empty circle and 1 for a black filled circle that prints on the lcd screen*/
                lcd.drawCircle(WIDTH/11,HEIGHT/1.97,5,0);       /*It calls the member function "drawCircle" inside the lcd class, with a WIDTH of 84/11, a HEIGHT of 48/1.97, a radius of 5, and a empty filled circle (0)*/
                lcd.drawCircle(WIDTH/11,HEIGHT/1.2,5,0);        /*It calls the member function "drawCircle" inside the lcd class, with a WIDTH of 84/11, a HEIGHT of 48/1.2, a radius of 5, and a empty filled circle (0)*/

                lcd.printString("PARKING",23,1);             /*Prints "Electrical" on the 6,2 X,Y axis coordinates of the LCD*/
                lcd.printString("RADAR",29,3);               /*Prints "Electrical" on the 6,2 X,Y axis coordinates of the LCD*/
                lcd.printString("SETTINGS",20,5);            /*Prints "Electrical" on the 6,2 X,Y axis coordinates of the LCD*/
                


                if (variableReading <= 0.3) {                                                    /*This is for the PARKING option*/
                    lcd.drawCircle(WIDTH/11,HEIGHT/5.2,5,1);  // x,y,radius,black fill
                    ledLaserA();
                    lcd.refresh();
                    ledLaserB();
                    lcd.drawCircle(WIDTH/11,HEIGHT/5.2,5,1);  // x,y,radius,black fill
                    lcd.refresh();

                    while(buttonFlag == 1) {
                        lcd.clear();
                        //buzzer.beep(200,1.5);
                        inLeds = 1;
                        if(LedFlag) { //if flag has been set
                            inLeds = inLeds + 1;
                            if(inLeds < 3) {
                                inLeds = 0;
                            }
                            LedFlag = 0;  //reset flag
                        }
                        int distReading = srf02.getDistanceCm();

                        lcd.clear();

                        char stringBuffer[14];

                        lcd.printString("Measured range",0,2);

                        sprintf(stringBuffer,":%dcm",distReading);

                        lcd.printString(stringBuffer,43,3);
                        lcd.refresh();

                        if (distReading >=12 && distReading <=15  ) {
                            pcbLEDS = 8;
                            lcd.printString("///*///*///*//",0,0);      //Y,X axis
                            lcd.printString("WELL DONE!",0,1);
                            lcd.printString("car parked at  ",0,2);
                            lcd.printString("///*///*///*//",0,4);      //Y,X axis
                            lcd.printString("///*///*///*//",0,5);      //Y,X axis
                            buzzer.beep(200,1.5);
                            wait(4);
                        }
                        if (distReading > 15 && distReading <= 30) {
                            pcbLEDS = 12;
                            lcd.printString("//////////////",0,0);      //Y,X axis
                            lcd.printString("wall at",0,3);
                            lcd.printString("Slow approach,",0,2);
                           // lcd.printString("recommended",0,4);
                            
                            wait_ms(300);
                        }
                        if (distReading > 30 && distReading <= 50) {
                            pcbLEDS = 14;
                            wait_ms(300);
                        }
                        if (distReading > 50 && distReading <= 50) {
                            pcbLEDS = 15;
                            wait_ms(300);
                        } else {
                            //pcbLEDS = 15;
//                    wait_ms(300);
//                    pcbLEDS = 0;
                            ledFlow();
                             lcd.refresh();
                        }
                        lcd.refresh();

                        //       if (distReading < 35) {
                        //  buzzer.beep(500,1.0);
//                    pcbLEDS = 14;
//                    wait_ms(300);
//
//                if (distReading < 25) {
//                   buzzer.beep(1000,1.0);
//                    pcbLEDS = 12;
//                    wait_ms(300);
//
//                if (distReading < 15) {
//                        buzzer.beep(9000,1.0);
//                        pcbLEDS = 8;
//                        wait_ms(300);
//                    } //close dist reading 15
//             lcd.refresh();
//                } //close dist reading 35
//            } //close button flag 1
//        } //close variable reading 0.3 to 0.6
                        lcd.refresh();
                    }
                    lcd.clear();

                    lcd.refresh();
                }

                if (variableReading >0.3 && variableReading <0.6) {
                    //This is the RADAR option
                    lcd.drawCircle(WIDTH/11,HEIGHT/1.97,5,1);  // x,y,radius,black fill
                    ledLaserA();
                    lcd.refresh();
                    ledLaserB();
                    lcd.drawCircle(WIDTH/11,HEIGHT/1.97,5,1);  // x,y,radius,black fill
                    lcd.refresh();

                    while(buttonAltFlag == 1) {
                        lcd.clear();
                        //buzzer.beep(200,1.5);
                        inLeds = 1;
                        if(LedFlag) { //if flag has been set
                            inLeds = inLeds + 1;
                            if(inLeds < 3) {
                                inLeds = 0;
                            }
                            LedFlag = 0;  //reset flag
                        }
                        int distReading = srf02.getDistanceCm();

                        lcd.clear();

                        char stringBuffer[14];

                        lcd.printString("Measured range",0,2);

                        sprintf(stringBuffer,": %d cm",distReading);

                        lcd.printString(stringBuffer,0,3);
                        lcd.refresh();

                        if (distReading <=15) {
                            pcbLEDS = 8;
                            wait_ms(300);
                        }
                        if (distReading > 15 && distReading <= 30) {
                            pcbLEDS = 12;
                            wait_ms(300);
                        }
                        if (distReading > 30 && distReading <= 50) {
                            pcbLEDS = 14;
                            wait_ms(300);
                        }
                        if (distReading > 50 && distReading <= 50) {
                            pcbLEDS = 15;
                            wait_ms(300);
                        } else {
                            //pcbLEDS = 15;
//                    wait_ms(300);
//                    pcbLEDS = 0;
                            ledFlow();
                        }
                        lcd.refresh();

                        //       if (distReading < 35) {
                        //  buzzer.beep(500,1.0);
//                    pcbLEDS = 14;
//                    wait_ms(300);
//
//                if (distReading < 25) {
//                   buzzer.beep(1000,1.0);
//                    pcbLEDS = 12;
//                    wait_ms(300);
//
//                if (distReading < 15) {
//                        buzzer.beep(9000,1.0);
//                        pcbLEDS = 8;
//                        wait_ms(300);
//                    } //close dist reading 15
//             lcd.refresh();
//                } //close dist reading 35
//            } //close button flag 1
//        } //close variable reading 0.3 to 0.6
                        lcd.refresh();
                    }
                }

                if (variableReading >= 0.6) {
                    //This is the the SETTINGS option
                    lcd.drawCircle(WIDTH/11,HEIGHT/1.2,5,1);  // x,y,radius,black fill
                    if(refLedFlag == 1) {
                        ledLaserA();
                        lcd.refresh();
                        ledLaserB();
                        refLedFlag = 0;
                    }
                    lcd.refresh();
                    lcd.drawCircle(WIDTH/11,HEIGHT/1.2,5,1);  // x,y,radius,black fill
                    //lcd.printString("SETTINGS",20,5);           //X,Y axis
                    // buzzer.beep(12000,1.0);
                    while(buttonSecondAltFlag == 1) {
                        lcd.clear();
                        variableReading = pot.read();   // This, has to beinside the while loop as otherwise it would not bear it in mind when coding
                        lcd.setBrightness(variableReading);
                        char stringBuffer[14];
                        lcd.drawRect(15,6.5,60,10,0);  // filled empty rectangle   Y,X,length, width,1=FILLIN/0=NON-FILLING
                        lcd.drawCircle(WIDTH/11,HEIGHT/4.7,5,1);  // x,y,radius,transparent with outline
                        lcd.printString("LCD lumen",19,1);
                        //  buzzer.beep(200,1.5);
                        //lcd.printString("Measured range",0,3);
                        float tempVarReading = variableReading * 100;
                        sprintf(stringBuffer,": %.1f%%",tempVarReading);
                        lcd.printString(stringBuffer,0,4);
                        lcd.refresh();
                        //buzzer.beep(200,1.5);
                        //lcd.refresh();
                        wait(0.4);

                        //         // wait(0.5);
                    }  //close while buttonSecondAltFlag
                }  //close if var reading greater than 0.6
            } //close while(1)
        }//close main

    //}
}
   