#ifndef MBEDTIMER_CLASS
#define MBEDTIMER_CLASS

#include "mbed.h"

class mbedTimer
{

private:
    int val_hour;
    int val_min;
    int val_sec;

public:


    char timeMessage[128];


    void sendMessage(int _val)
    {
        val_hour = _val/3600;
        val_min = (_val%3600)/60;
        val_sec = _val%60;


        if(val_sec<10) {
            if(val_min<10) {
                snprintf(timeMessage, 128, "%d:0%d:0%d",val_hour,val_min,val_sec);
            } else {
                snprintf(timeMessage, 128, "%d:%d:0%d",val_hour,val_min,val_sec);
            }

        } else {
            if(val_min<10) {
                snprintf(timeMessage, 128, "%d:0%d:%d",val_hour,val_min,val_sec);
            } else {
                snprintf(timeMessage, 128, "%d:%d:%d",val_hour,val_min,val_sec);
            }
        }

    }

};

#endif