#include "MU2.h"

#include "stdint.h"
#include <string>
#include <sstream>

MU2::MU2(PinName tx,PinName rx):MuPort(tx,rx)//MU2クラスのMU2という関数(コンストラクタ)の定義
{
    MuPort.baud(19200);
    _tx=tx;
    _rx=rx;
}


void MU2::send(char Message[])
{


    //MuPort.baud(9600);//19200?
    //pc.baud(19200);//9600

    int index=0;
    std::string send_data;

    uint8_t last_data[]= {0x0d,0x0a}; //復帰、改行のアスキーコードを16進数で表す


    int j=0;
    while(Message[j]!='\0')  {
        j++;
    }
    index=j;//


    send_data="@DT";

    if(index<16) {
        std::stringstream ss;  //stiringstreamクラスのstd::hexマニュピレータを用いて変換。<sstream>のincludeが必要。
        ss << std::hex << index ; //indexを16進数に変換
        std::string str_ss = ss.str();
        send_data += '0';
        send_data += str_ss;
    } else {
        std::stringstream ss;  //stiringstreamクラスのstd::hexマニュピレータを用いて変換。<sstream>のincludeが必要。
        ss << std::hex << index ; //indexを16進数に変換
        std::string str_ss = ss.str();
        send_data += str_ss;
    }


    for(int n=0; n<index+1; n++) {
        send_data += Message[n];
    }


    //pc.printf("%s\n",send_data.c_str());
    //pc.printf("%s\n",Message);


    MuPort.printf("%s", send_data.c_str());//.c_str()でstring型のstrを変換


    for(int l=0; l<2; l++) {
        MuPort.putc(last_data[l]);
    }
}