#include "chara.h"

void chara::init(){
    int d[56] = {
            0,0,1,1,1,0,0,
            0,0,1,0,1,0,0,
            0,0,1,1,1,0,0,
            1,1,0,1,0,0,0,
            1,0,1,1,1,1,0,
            1,0,1,1,0,0,0,
            1,1,0,0,1,0,0,
            0,0,0,0,1,0,0
            };
    for(int i = 0; i<56;i++){
        data[i] = d[i];
    }
    _xy.x = 0;
    _xy.y = 25;
}

void chara::update(Gamepad &pad, FXOS8700CQ &device){
    Data values = device.get_values();
              
    if(pad.get_direction() == N){
        _xy.y = _xy.y -4;
    }else{
        _xy.y = _xy.y + 2;
    }
    
    if(values.ay>=0){
        _xy.x = _xy.x - int(values.ay*10);
    }else if(values.ay<=0){
        _xy.x = _xy.x - int(values.ay*10);
    }
    
    if(_xy.x>=77){
        _xy.x = 77;
    }else if(_xy.x<=0){
        _xy.x=0;
    }
    if(_xy.y>=41){
        _xy.y = 41 ;
    }else if(_xy.y<=7){
        _xy.y=7;
    }
}

void chara::display(N5110 &lcd){
        Bitmap c(data, 8, 7);
        c.render(lcd, _xy.x, _xy.y);
}

xy chara::getxy(){return _xy;}


