/*
* -----------------------------------------
* Trigger_LabSat_variant_1 1.0 (2018-04-05)
* -----------------------------------------
* Works well with NUCLEO-F031K6 and NUCLEO-F411RE.
*
* In     (D2): ---_------_---
*
* Out    (D3): ___--------___
*
* negOut (D4): ---________---
*
* LED  (LED1): ___--------___
*
* Copyright (c) 2018, Martin Wolker (neolker@gmail.com)
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     - Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     - Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     - Neither the name of Martin Wolker nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL MARTIN WOLKER BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "mbed.h"
#define TRIGGER_IGNORE_LENGTH_MS   500

InterruptIn trigger_in(D2);
DigitalOut  trigger_out(D3);
DigitalOut  trigger_out_negative(D4);
DigitalOut  trigger_led(LED1);

void trigger(void)
{
    trigger_out =! trigger_out;
    trigger_out_negative =! trigger_out_negative;
    trigger_led =! trigger_led;
}

void interrupt(void)
{
    trigger();
    wait_ms(TRIGGER_IGNORE_LENGTH_MS);
}

int main(void)
{
    //Trigger interrupt by falling edge
    trigger_in.fall(&interrupt);

    //Default state
    trigger_out = 0;
    trigger_out_negative = 1;
    trigger_led = 0;

    //Endless loop
    while(1) { }
}