/*
* ----------------------------
* TriggerNiNo 1.0 (2016-09-26)
* ----------------------------
* LVTTL HW Trigger with control via virtual Serial over USB.
* Works well with NUCLEO-F031K6 and NUCLEO-F411RE.
*
* Copyright (c) 2016, Martin Wolker (neolker@gmail.com)
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*     - Redistributions of source code must retain the above copyright
*       notice, this list of conditions and the following disclaimer.
*     - Redistributions in binary form must reproduce the above copyright
*       notice, this list of conditions and the following disclaimer in the
*       documentation and/or other materials provided with the distribution.
*     - Neither the name of Martin Wolker nor the
*       names of its contributors may be used to endorse or promote products
*       derived from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED. IN NO EVENT SHALL MARTIN WOLKER BE LIABLE FOR ANY
* DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
* LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "mbed.h"
#define TRIGGER_PULSE_LENGTH_MS   500

Serial pc(USBTX, USBRX);
DigitalOut trigger_output_positive(D2);
DigitalOut trigger_output_negative(D3);
DigitalOut trigger_indication(LED1);

void trigger(void)
{
    trigger_output_positive =! trigger_output_positive;
    trigger_output_negative =! trigger_output_negative;
    trigger_indication =! trigger_indication;
}

void interrupt(void)
{
    pc.getc();
    trigger();
    wait_ms(TRIGGER_PULSE_LENGTH_MS);
    trigger();
}

int main(void)
{
    pc.attach(&interrupt);
    trigger_output_positive = 0;
    trigger_output_negative = 1;
    trigger_indication = 0;
    while(1) {}
}