#include <mbed.h>
class RS485 : public Serial
{
public:
    /** Create a RS485 Serial port using MAX485, connected to the specified transmit and receive pins
     *
     *  @param tx Transmit pin
     *  @param rx Receive pin
     *  @param mode Rx TX Mode pin
     *
     *  @note
     *    Either tx or rx may be specified as NC if unused
     */
    RS485(PinName tx, PinName rx, PinName mode, const char *name=NULL);
    
protected:    
    virtual int _putc(int c);
    virtual int _getc();

private:
    DigitalOut m_modePin;
         
};