#include "mbed.h"
#include "DS1820.h"
//ESTADOS DE LA FUNCION PRINCIPAL
#define LAZOABIERTO     0
#define LAZOCERRADO     1
//ESTADOS DE LA FUNCION DE PULSADORES
#define HIGH    0
#define FD      1
#define LOW     2
#define FA      3
//ESTADOS DE LOS LEDS
#define ON      0
#define OFF     1
//DEFINICION DE ENTRADAS Y SALIDAS
DS1820 probe(A2);       //SENSOR DS18B20
Serial pc(USBTX, USBRX);        //COMUNICACION SERIAL CON LA PC
DigitalIn pulsador(PTB8);       //PULSADOR PARA EL CAMBIO ENTRE LAZOS
AnalogIn mypotentiometer(A0);   //ENTRADA ANALÓGICA DE LOS POTENCIÓMETROS
InterruptIn efecto_hall(D8);    //INTERRUPCIONES PARA EL SENSOR DE EFECTO HALL
PwmOut mycooler(A1);            //SALIDA PWM PARA EL COOLER
DigitalOut led_rojo(LED_RED);   //LED ROJO
DigitalOut led_azul(LED_BLUE);  //LED AZUL
Ticker tiempo;                  //TICKER DE TIEMPO
Timer t;                        //TIMER: MEDICION DE PULSOS EFECTO HALL
//PROTOTIPOS DE LAS FUNCIONES
void TimerALL();            //FUNCION DEL TICKER
void Debounce_Pulsador();   //FUNCION PARA QUITAR EL ANTIRREBOTE
void CoolerFSM();           //FUNCION PRINCIPAL DEL PROGRAMA
void flanco_asc();          //FUNCION PARA DETECTAR FLANCO ASCENDENTE DEL EFECTO HALL
void flanco_des();          //FUNCION PARA DETECTAR FLANCO DESCENDENTE DEL EFECTO HALL
//VARIABLES
int lazo_estados = 0;       //VARIABLE DEL CAMBIO DE ESTADO FUNCION PRINCIPAL
int pul = 0;                //ESTADO DEL PULSASDOR
int deb_p1_estados = 0;     //VARIABLE DE CAMBIO DE ESTADO FUNCION PULSADORES ANTIRREBOTE
int tdb = 0;                //VARIABLE DE TIEMPO UTILIZADA PARA EL ANTIRREBOTE
bool newdata = false;       
bool estpul = false;        
int c = 1000;               //VARIABLE DE TIEMPO PARA ENVIO DE INFORMACION
float t_pulse = 0;          //VARIABLE QUE CONTIENE EL VALOR DEL ANCHO DEL PULSO DEL EFECTO HALL
float rpm = 0;              //VARIABLE QUE CONTIENE LAS RPMS MEDIDAS
int j = 100;            
//FUNCION MAIN
int main() {
    //DEFINICION DL TICKER
    tiempo.attach(&TimerALL,0.001);
    //PULL UP DEL PULSADOR DE CAMBIO DE LAZOS
    pulsador.mode(PullUp);
    //INTERRUPCION PARA DETECCION DE FLANCO ASCENDENTE
    efecto_hall.rise(&flanco_asc);
    //INTERRUPCION PARA DETECCION DE FLANCO DESCENDENTE
    efecto_hall.fall(&flanco_des);
    //DEFINICION DEL PERIODO DEL PWM QUE ES ANVIADO AL COOLER
    mycooler.period(0.001f);
    led_rojo = ON;
    led_azul = OFF;
    while(1) {
        probe.convertTemperature(false, DS1820::all_devices);         //Start temperature conversion, wait until ready
        CoolerFSM();
    }
}
//FUNCION PRINCIPAL QUE CONTROLA LOS LAZOS DEL COOLER
void CoolerFSM(){
    switch(lazo_estados){
        default:
        //LAZO ABIERTO: CONTROL POR PARTE DEL POTENCIOMETRO
        case LAZOABIERTO:
            //AVISO DE QUE SE TRABAJA EN LAZO ABIERTO
            if(newdata == false){
                pc.printf("\r\nEstoy en Lazo Abierto\n\r");
                newdata = true;   
            }
            //REVISION POR SI EXISTE UN CAMBIO DE LAZO
            //AL APRETAR EL PULSADOR
            Debounce_Pulsador();
            //SI LA VARIABLE PUL ESTA EN 1 Y LA VARIABLE
            //DE LOS ESTADOS DE LA FUNCION DEBOUNCE_PULSADOR ESTA EN HIGH
            //SE CAMBIA DE LAZO, Y SE ENCIENDE EL LED AZUL PARA INDICAR
            //EL LAZO CERRADO
            if(pul == 1 && deb_p1_estados == HIGH){
                lazo_estados = LAZOCERRADO;
                mycooler = 0.0f;
                led_rojo = OFF;
                led_azul = ON;
                newdata = false;}
            break;
        //LAZO CERRADO CONTROL POR PARTE DEL SENSOR DE TEMPERATURA
        case LAZOCERRADO:            
            //AVISO DE QUE S TRABAJA EN LAZO CERRADO
            if(newdata == false){
                newdata = true;
                pc.printf("\r\nEstoy en Lazo Cerrado\n\r"); 
            }
            //REVISION POR SI EXISTE UN CAMBIO DE LAZO
            //AL APRETAR EL PULSADOR
            Debounce_Pulsador();
            //SI LA VARIABLE PUL ESTA EN 0 Y LA VARIABLE
            //DE LOS ESTADOS DE LA FUNCION DEBOUNCE_PULSADOR ESTA EN HIGH
            //SE CAMBIA DE LAZO, Y SE ENCIENDE EL LED ROJO PARA INDICAR
            //EL LAZO ABIERTO
            if(pul == 0 && deb_p1_estados == HIGH){
                led_rojo = ON;
                led_azul = OFF;
                lazo_estados = LAZOABIERTO;
                newdata = false;}
            break;
    }
}
//INTERRUPCION DE FLANCO ASCENDENTE
void flanco_asc() {
    //SIEMPRE QUE SE INICIA LA INTERUPCION
    //SE RESETEA EL TIMER Y SE LO INICIA
    //EMPEZANDO EL CONTEO DEL TIEMPO
    t.reset();
    t.start();
}
//INTERRUPCION DE FLANCO DESCENDENTE
void flanco_des(){
    //CUANDO SE DETECTA FLANCO DESCENDENTE
    //SE FRENA EL TIMER. LUEGO SE LEE EL 
    //VALOR Y SE LO GUARDA EN UNA VARIABLE
    //FINALMENTE SE REALIZA UNA OPERACION PARA
    //DETERMINAR LAS RPM
    t.stop();
    t_pulse = t.read();
    //PARA OBTENER LA CANTIDAD DE RPMS: SE
    //DIVIDEN LOS 60 SEGUNDOS QUE CONFORMAN
    //1 MINUTO POR EL ANCHO DEL PULSO GUARDADO
    //CON ANTERIORIDAD
    if(t_pulse < 0.025 && t_pulse > 0.005)
        rpm = 60.0f/(t_pulse * 4.0f);
}

void Debounce_Pulsador(){
    switch(deb_p1_estados){
        default:
        case HIGH:
            estpul = false; 
            if(pulsador == 0){
                tdb = 5; 
                deb_p1_estados = FD;}
            break;
        case FD:
            if(pulsador == 1 && tdb != 0)
                deb_p1_estados = HIGH;
            if(pulsador == 0 && tdb == 0)
                deb_p1_estados = LOW;
            break; 
        case LOW:
            if(estpul == false && pul == 0){
                pul = 1;
                estpul = true;
            }
            if(estpul == false && pul == 1){
                pul = 0;
                estpul = true;
            }
            if(pulsador == 1){
                tdb = 5;
                deb_p1_estados = FA;}
            break;
        case FA:
            if(pulsador == 1 && tdb == 0)
                deb_p1_estados = HIGH;
            if(pulsador == 0 && tdb != 0)
                deb_p1_estados = LOW;
            break;
    }
}
//EL TICKER ES UTILIZADO PARA TRES COSAS
//CONTROL DEL DUTY DEL PWM DEL COOLER
//CONTROL DEL TIEMPO DEL ANTIRREBOTE
//CONTROL DEL ENVIO DE INFORMACION CADA CIERTO TIEMPO
void TimerALL(){
    if(j > 0)
        j--;
    if(lazo_estados == LAZOABIERTO && deb_p1_estados == HIGH && j == 0){
        mycooler = mypotentiometer;
        j = 100;} 
    if(lazo_estados == LAZOCERRADO && deb_p1_estados == HIGH && j == 0){
        mycooler = (probe.temperature()-7.5f)/62.5f;
        j = 100;}
    if(tdb > 0)
        tdb--;
    if(c > 0)
        c--;
    if(c == 0){
        pc.printf("\r\nRPM: %f",rpm);
        pc.printf("\r\nPotenciometro: %f%%",mypotentiometer.read()*100.0f);
        pc.printf("\r\nCooler: %f%%",mycooler.read()*100.0f);
        pc.printf("\r\nTemp: %3.1foC \r\n", probe.temperature());
        c = 1000;
    }
}