#include "mbed.h"
#include "EthernetInterface.h"

#include "NetworkAPI/buffer.hpp"
#include "NetworkAPI/ip/address.hpp"
#include "NetworkAPI/tcp/socket.hpp"

int
main()
{
    EthernetInterface interface;
    interface.init();
    interface.connect();
    printf("IP Address is %s\n\r", interface.getIPAddress());
  
    int result;
  
    network::tcp::Socket socket;
    network::Buffer buffer(256);
    std::string request("GET /media/uploads/donatien/hello.txt HTTP/1.1\r\nHost: %s\r\n\r\n");
    
    if (socket.open() < 0) {
        printf("Failed to open TCP Socket\n\r");
        return -1;
    }
    
    if (socket.connect("mbed.org", 80) < 0) {
        printf("Failed to connect with mbed.org\n\r");
        return -1;
    }
    
    if (socket.write((void *)request.data(), request.size()) < 0) {
        printf("Failed to write HTTP request\n\r");
        return -1;
    }
    
    do
    {
        result = socket.read(buffer);   
        printf("Received %d bytes:\n\r%s\n\r", result, (char *)buffer.data());
    } while(result > 0);
    
    socket.close();
    return 0;
}