/**
 * Copyright (c) 2010 Roy van Dam <roy@negative-black.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "mbed.h"
#include "SHTx/sht15.hpp"

Serial pc(USBTX, USBRX);
DigitalOut busy(LED1);

// I used p9 and p10 here  but you
// can use any other GPIO as well.
SHTx::SHT15 sensor(p9, p10);

int
main() {
    // Speed things up a bit.
    sensor.setOTPReload(false);
    sensor.setResolution(true);
    
    while(1) {
        busy = true;
        sensor.update();
        busy = false;
        
        // Temperature in celcius
        sensor.setScale(false);
        pc.printf("Temperature [ %3.2f C ]\r\n", sensor.getTemperature());
        
        // Temperature in fahrenheit
        sensor.setScale(true);
        pc.printf("            [ %3.2f F ]\r\n", sensor.getTemperature());
        
        // Relative Humidity
        pc.printf("Humdity     [ %3.2f %% ]\r\n\n", sensor.getHumidity());
        
        wait(5);
    }
}
