/**
 * Copyright (c) 2012, Roy van Dam <roy@vandam-innovations.com>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _CONTROLLER_HPP_
#define _CONTROLLER_HPP_

#include <cstdio>
#include <cstring>
#include <vector>

#include "mbed.h"

#include "NetworkAPI/select.hpp"
#include "NetworkAPI/tcp/socket.hpp"

class Controller
{
    protected:
        typedef std::vector<DigitalOut *> DigitalOutputList;
        typedef std::vector<DigitalIn  *> DigitalInputList;
        
        struct {
            DigitalOutputList output;
            DigitalInputList input;
        } _io;
                    
        struct {
            network::tcp::Socket server;
            network::tcp::Socket client;
        } _network;
        
        enum Command {
            C_None,
            C_Read,
            C_Write
        };
        
        enum ParseState {
            S_Init,
            S_Index,
            S_Execute,
        };
        
        enum ParseError {
            E_None              =  0,
            E_Internal          = -1,
            E_InvalidCommand    = -2,
            E_InvalidFormat     = -3,
            E_UnknownIndex      = -4,
            E_InvalidValue      = -5
        };

    public:
        ~Controller();
        
        int start(int port = 61850, int max_pending = 1);
        int stop();
        
        int dispatch();
                
        int addOutput(DigitalOut *output);
        DigitalOut *getOutput(size_t index);
        
        int addInput(DigitalIn *input);
        DigitalIn *getInput(size_t index);
        
    protected:
        bool _outputExists(DigitalOut *output);
        bool _inputExists(DigitalIn *input);
        
        int _parseCommand(network::Buffer &buffer);
};

#endif // _CONTROLLER_HPP_