#include "mbed.h"
#include "EthernetInterface.h"

#include "NetworkAPI/ip/address.hpp"
#include "NetworkAPI/udp/socket.hpp"

int
main()
{
    EthernetInterface interface;
    interface.init();
    interface.connect();
    printf("IP Address is %s\n\r", interface.getIPAddress());
  
    network::udp::Socket socket;
    char buffer[1024];
    int result = 0;
    
    if (socket.open() < 0) {
        printf("Failed to open UDP Socket\n\r");
        return -1;
    }
    
    if (socket.bind(42) < 0) {
        printf("Failed to bind UDP Socket to port 42\n\r");
    }
    
    while (true) {
        result = socket.receive(buffer, 1024);
        
        switch (result) {
            case -1:
                printf("Failed to read from UDP Socket\n\r");
                return -1;
            
            case 0:
                printf("Nothing received...?\n\r");
                continue;
            
            default:
                printf("Received %d bytes from %s:%d\n\r", result,
                    socket.getRemoteEndpoint().getAddress().toString().c_str(),
                    socket.getRemoteEndpoint().getPort());
                
                if (!socket.getRemoteEndpoint().getAddress().isEmpty()) {
                    socket.send(buffer, result, socket.getRemoteEndpoint());
                }
                continue;
       }
    }
        
    return 0;
}