#include "mbed.h"
#include "EthernetInterface.h"

#include "NetworkAPI/ip/address.hpp"

int
main()
{
    EthernetInterface interface;
    interface.init();
    interface.connect();
    printf("IP Address is %s\n\r", interface.getIPAddress());

    network::ip::Address address;
    address.fromHostname("www.google.nl");
    
    printf("Network address %s\n", address.toString().c_str());
    return 0;
}