#include "mbed.h"
#include "WiflyInterface.h"
#include "Ping.h"

#define ECHO_SERVER_PORT   12345
#define MY_NODE_ID 1

Ping Pinger(p21);
AnalogIn t(p19);        //TMP36 is connected here
AnalogIn l(p18);
DigitalIn PIR(p17);
PwmOut dimmer(p22);
PwmOut servo(p24);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut myled4(LED4);
DigitalIn cam(p16);

extern "C" void mbed_reset();

/* wifly object where:
*     - p9 and p10 are for the serial communication
*     - p25 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p25, p26, "solarskin", "solarskin", WPA);

class Watchdog {
public:
// Load timeout value in watchdog timer and enable
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x1;                // Set CLK src to PCLK
        uint32_t clk = SystemCoreClock / 16;    // WD has a fixed /4 prescaler, PCLK default is /4
        LPC_WDT->WDTC = s * (float)clk;
        LPC_WDT->WDMOD = 0x3;                   // Enabled and Reset
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};

Watchdog wdt;

int main (void)
{
    wifly.init("192.168.1.101","255.255.255.0","192.168.1.1"); // use Static
    //wifly.init();
    while (!wifly.connect()); // join the network
    printf("IP Address is %s\n\r", wifly.getIPAddress());
    
    TCPSocketServer server;
    server.set_blocking(false, 1500);
    server.bind(ECHO_SERVER_PORT);
    server.listen();
        
    printf("\nWait for new connection...\n");
    TCPSocketConnection client;
    server.accept(client);
    client.set_blocking(false,1500);
    wdt.kick(10.0);
    
    char buffer[256];
    char b='0';
    char dim = '0';
    char data[256];
    float temp_c;
    char fan = '0';
    char camera = '0';
    long count=0;
    float range = 0;
    int packet_no=1;
    char motion = '0';
    int n = 9;
    
    float personCounter = 0;
    bool personFlag = false;
        
    float tempAvg = 0;
        
    int lightIter=0;
    
    while (true) 
    { 

            if(lightIter == 0)
            {
                led3=0;
                motion = '0';
            }
            lightIter++;
            
            if(lightIter == 10)
                lightIter = 0;
                
            if(!PIR)
            {
                led3 = 1;
                motion = '1';
                lightIter = 1;
            }
          
            if(!cam){camera = '1'; myled4=1;}else{camera='0';myled4=0;}
            
            temp_c=((t.read()*330.0)-50)+7;
            
            tempAvg = temp_c +tempAvg;
            
            printf("\rtemp is%d\n",(int)temp_c);
            if(!PIR){
                led3 = 1;
                motion = '1';
                lightIter = 1;
            }
            
            if(!cam){camera = '1'; myled4=1;}else{camera='0';myled4=0;}
            
            float light = l.read_u16();
            
            printf("\rlight value is %f\n",light);
            if(!PIR){
                led3 = 1;
                motion = '1';
                lightIter = 1;
            }
           
            if(!cam){camera = '1'; myled4=1;}else{camera='0';myled4=0;}
            Pinger.Send();    
            wait_ms(30);
            range = Pinger.Read_cm();
            
            if(range < 60.0 && range >= 0.0 && personFlag == false)
            {
                personFlag = true;
                personCounter = personCounter + 1.0;
            }
            if(range >= 60.0 && personFlag == true)
            {
                personFlag = false;
            }
            printf("\rPerson counter is %f\n",range);
            
            if(!PIR){
                led3 = 1;
                motion = '1';
                lightIter = 1;
            }
            
            if(!cam){camera = '1'; myled4=1;}else{camera='0';myled4=0;}
            if (temp_c >25 || (b==49))
            {   
                fan = '1';
                led1 = 1;
                servo.pulsewidth(0.002);
                wait(1);
            }
            if (temp_c <=25 && (b==48))
            {
               fan = '0';
               servo.pulsewidth(0);
               wait(1);
            }
            if(!cam){camera = '1'; myled4=1;}else{camera='0';myled4=0;}
            
           // 
            
            if(((dim-48) == 0 || (dim-48) == 1) && motion == '1')
            {
                dimmer = 0.07;
            }
            else
            {
                dimmer = 0.01286 * (dim-48) - .015714;
            }
            
            if(!cam){camera = '1'; myled4=1;}else{camera='0';myled4=0;}
            
            n = client.receive(buffer, sizeof(buffer));
            printf("\r N = %d\n",n);
           
            count++;
            
            
            
            //if (count>10) { mbed_reset(); count=0;} 
            
            if (n>1)
            {
                printf("Received bytes %d",n);
                for (int i=5;i<n;i++)    
                //printf("5%c 6%c 7%c 8%c 9%c 10%c",buffer[5],buffer[6],buffer[7],buffer[8], buffer[9], buffer[10]);
                printf("%d, %c\t",i,buffer[i]);
                printf("\n");
                if (buffer[7] == 49 || buffer[7]==48) 
                    b=buffer[7];
                    
                if(buffer[18]>=48 && buffer[18]<=57) 
                    dim = buffer[18];
                 
                data[3]=(int)motion;
                data[5]=personCounter;
                data[4]=packet_no;
                data[0]=(int)temp_c;
                data[1]=(int)(light/100);
                data[2]=range;
                data[6]=(int)fan;
                data[7]=(int)camera;
                data[8] =(int)(tempAvg/count);
                data[9]='\0';
            
                n=sprintf(buffer,"%s",data);
                printf("\n\n");
                client.send_all(buffer, n);
                packet_no++;
                
                
                for (int i=5; i<n; i++)
                {
                    buffer[i]='0';
                }
            }
           
            
            
            wdt.kick();
        }
        client.close(); //Closes the connection with the client
}