#include "LPC17xx.h"
#include "mbed.h"

Serial pc(USBTX,USBRX);

int main()
{
    // initialize the LED pins as outputs
    //LPC_GPIO1->FIODIR = 1 << 18 | 1 << 27;
    // PIN P26 is the output pin!
    pc.printf("Welcome to LPC1768 PWM demo\n\r");
    // ensure PWM peripheral is powered on (it is powered on by default)
    LPC_SC->PCONP |= 1 << 6;
    LPC_PWM1->TCR = 2;                      // bring PWM module into reset
    LPC_PWM1->IR = 0xff;                    // clear any pending interrupts
    // configure P2.0 for PWM1.1 - O - Pulse Width Modulator 1, channel 1 output.
    LPC_PINCON->PINSEL4 = (LPC_PINCON->PINSEL4 & ~(0x3 << 0)) | (0x1 << 0);
    // Disable pullups for P2.0
    LPC_PINCON->PINMODE4 = (LPC_PINCON->PINMODE4 & ~0x3) | 0x2;
    // Set prescale so we have a resolution of 1us
    LPC_PWM1->PR = SystemCoreClock / (4 * 1000000) - 1; 
    LPC_PWM1->MR0 = 20000;                  // set the period in us. 50Hz rate
    LPC_PWM1->MR1 = 1500;                   // set duty of 1.5ms
    LPC_PWM1->MR2 = 19000;                  // set a match that occurs 1ms before the TC resets.
    LPC_PWM1->LER = 0x07;                    // set latch-enable register
    LPC_PWM1->MCR = 0x02 | (1 << 6);         // reset on MR0, interrupt on MR2
    LPC_PWM1->PCR = 1 << 9;                 // enable PWM1 with single-edge operation
    LPC_PWM1->TCR = (1 << 3) | 1;           // enable PWM mode and counting
    while(1) {
        // wait for MR2 interrupt flag to be raised 
        while((LPC_PWM1->IR & (1 << 2)) == 0);
        LPC_PWM1->IR = 0xff;              // clear interrupt flags
        // write duty cycle value and set Latch-enable register
        LPC_PWM1->MR1 = 10000; //from 200 = 1% and 20000 = 100%
        LPC_PWM1->LER = 1 << 1;
    }

}
