#include "mbed.h"

Serial pc(USBTX, USBRX);
InterruptIn in(p8);
DigitalOut led(LED1);
DigitalOut led2(LED2);
Timer t1;

float t_period = 0;                   // This is the period between interrupts in microseconds
float t_freq = 0;

void flip(void)
{
    led=!led;
    t_period = t1.read_us();                // Get time since last interrupt
    t_freq = (1/t_period)*1000000;   // Convert period (in us) to frequency (Hz)
    t1.reset();                             // Reset timer and wait for next interrupt
}

int main() {
    pc.printf("\rStarting frequency counter\n");
    in.mode(PullDown);              // Set the pin to Pull Down mode.
    in.rise(&flip);                 // Set up the interrupt for rising edge
    t1.start();                     // start the timer
      
    while (1) {
        wait_ms(100);
        led2=!led2;
        pc.printf("\rfrq is %d Hz\n", (int)t_freq);
    }

}