#include "mbed.h"
#include "SDFileSystem.h"

const float rpm_scale=0.39063; //scala di conversione
const float P_olio_scale=0.580151*0.0689476;

CAN can(D10,D2); //Rx & TX da mettere con PB_12, PB_13
Serial pc(USBTX, USBRX); // tx, rx

SDFileSystem sd(A6, A5, A4, A3, "sd"); // the pinout on the mbed Cool Components workshop board
int n = 0;
 
FILE *fp; 

DigitalIn mybutton(D1);            

int rpm;
 
typedef struct {
    uint16_t ax;
    uint16_t ay;
    uint16_t az;
    uint16_t gx;
    uint16_t gy;
    uint16_t gz;             
} message_t; 

void inviaMessaggio(int ax,int ay,int az,int gx,int gy,int gz){
        message_t message;
        message.ax = ax;
        message.ay = ay;
        message.az = az;
        message.gx = gx;
        message.gy = gy;
        message.gz = gz;
        fwrite(&message, sizeof(message_t), 1, fp); 
}
 
int main() {
    printf("Sono partito\n");   
 
    mkdir("/sd/mydir", 0777);
    
    fp = fopen("/sd/mydir/1.txt", "a");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    //fprintf(fp, "Hello fun SD Card World!");
    
    unsigned int bb;
    pc.baud(921600);
    CANMessage msg;
    //wait(15);
    wait_ms(100);
    pc.printf("\t CANBUS Attivo!! \r\n\n");
   
    can.frequency(500000);
    fprintf(fp, "NN\n\r");
    while(1){
        wait_ms(50);
        //(inviaMessaggio(600, 600, 600, 6500, 6500, 6500);
        /*The control unit sends all the data that it carries on the can-bus, they are subdivided into various packs with various labels, depending on the data extraction log.
         As the data we are interested in is subdivided into various different address packets.
         Since the unsupported but unsolicited mails take them all in this way in the end I'm sure the updated data will be true to the last 50 ms */
        for(int i=0;i<50;i++){
            wait_us(1);
            if(can.read(msg)) {
              //led1= !led1;
              //printf("%d\r\n",msg.id);
              switch (msg.id){
                case(0x1f0a000):
                unsigned int rpm_msb=msg.data[0]; //primo byte dei giri motore
                unsigned int rpm_lsb=msg.data[1]; //secondo byte dei giri motore
            //    int rpm= (rpm_msb+rpm_lsb<<8)*rpm_scale;  //rpm complessivo tenendo conto del peso dei primi 8 bit e della scala di conversione;
               
                    /*rpm=rpm_msb*256;
                    rpm=rpm+rpm_lsb;
                    rpm=rpm*rpm_scale;*/
                    fprintf(fp, "%d %d\n\r", rpm_msb, rpm_lsb);
                    pc.printf("rpm= %d %d\n\r",rpm_msb, rpm_lsb);
        break;
        case(0x1f0a004):
        //      pc.printf("P_olio= %f\r\n",msg.data[4]*P_olio_scale);
              printf("\tolio= %f \n\r",msg.data[4]*P_olio_scale);
                    
        }
        
        }
        if((can.rderror()+can.tderror()))pc.printf("Errori! : rd: %d\t td: %d\r\n",can.rderror(),can.tderror());   
        wait_us(10);
        }
        if (mybutton == 0) {
            //chiusuraFile();
            //aperturaFile(); 
            //fprintf(fp, "###########FLAG MARCATORE PRESSIONE PULSANTE############\r\n");
            fprintf(fp, "NN %d\n\r", n);
            printf("flag\n\r");
            n++;
            wait(1); 
        }
    }
    //fclose(fp); 
 
    //printf("Goodbye World!\n");
}
