#include "mbed.h"

CAN can(D10,D2);
I2C i2c(D4, D5);
Serial pc(USBTX, USBRX);

int main() {
    CANMessage msg;
    wait_ms(100);
    can.frequency(500000);
    
    while(1) {
        if(can.read(msg)){
            switch (msg.id){
                case(0x1f0a000):
                    unsigned int rpm_msb=msg.data[0]; //primo byte dei giri motore
                    unsigned int rpm_lsb=msg.data[1];
                    int rpm = (rpm_msb+rpm_lsb<<8)*rpm_scale;
                    pc.printf("GIRI= %d %d\n\r",rpm_msb, rpm_lsb);
                    //logica accensione led
                break;
                case(0x1f0a003):
                    pc.printf("M= %d \n\r",msg.data[3]);
                    //logica accensione 7seg
                break;
            }
        }
    }
}
