#include "max7219.h"

void printNumber(uint16_t number, uint8_t noOfDigits);

Max7219 max7219(D11, NC, D13, D10);//D11->MOSI - 15(Nucleo), MISO, D13->CLK ->11(Nucleo), D10->CS -17(Nucleo)
uint8_t numberOfDevices = 4;

//DigitalOut my_sck(D13);

const unsigned char num1[]= {
    0x00,0x00,0x00,0x42,0x7F,0x40,0x00,0x00
};  //1
const unsigned char num2[]= {
    0x00,0x46,0x61,0x51,0x49,0x46,0x00,0x00
};  //2
const unsigned char num3[]= {
    0x00,0x22,0x41,0x49,0x49,0x36,0x00,0x00
};  //3
const unsigned char num4[]= {
    0x00,0x0C,0x0A,0x09,0x7F,0x08,0x00,0x00
};  //4
const unsigned char num5[]= {
    0x00,0x00,0x4F,0x49,0x49,0x31,0x00,0x00
};  //5
const unsigned char num6[]= {
    0x00,0x00,0x3C,0x4A,0x49,0x30,0x00,0x00
};  //6
const unsigned char num7[]= {
    0x00,0x00,0x61,0x11,0x09,0x07,0x00,0x00
};  //7
const unsigned char num8[]= {
    0x00,0x00,0x36,0x49,0x49,0x36,0x00,0x00
};  //8
const unsigned char num9[]= {
    0x00,0x00,0x06,0x49,0x49,0x3E,0x00,0x00
};  //9
const unsigned char num0[]= {
    0x00,0x00,0x3E,0x41,0x41,0x3E,0x00,0x00
};  //0

uint8_t smiley[] = {0x3c, 0x42, 0x81,0xA5, 0x81, 0xA5, 0x5A, 0x3C};
uint8_t numberFont[10][8] = {
    0x18,0x24,0x24,0x24,0x24,0x24,0x18,0x00,//0
    0x08,0x18,0x08,0x08,0x08,0x08,0x1C,0x00,//1
    0x38,0x44,0x44,0x08,0x10,0x20,0x7C,0x00,//2
    0x38,0x44,0x04,0x18,0x04,0x44,0x38,0x00,//3
    0x18,0x28,0x48,0x7C,0x08,0x08,0x08,0x00,//4    
    0x3C,0x20,0x20,0x38,0x04,0x04,0x38,0x00,//5    
    0x08,0x10,0x20,0x38,0x24,0x24,0x18,0x00,//6
        
    0x3C,0x04,0x04,0x08,0x10,0x20,0x20,0x00,//7    
    0x18,0x24,0x24,0x18,0x24,0x24,0x18,0x00,//8
    0x18,0x24,0x24,0x1C,0x04,0x04,0x18,0x00,//9
    };
    
int main()
{
    uint8_t col = 0;
    uint8_t row = 0;
    
    max7219.set_num_devices(numberOfDevices);
    
    max7219_configuration_t cfg = {
        .device_number = 1,
        .decode_mode = 0,
        .intensity = Max7219::MAX7219_INTENSITY_3,
        .scan_limit = Max7219::MAX7219_SCAN_8
    };
    wait_ms(100);
       max7219.init_display(cfg);
    wait_ms(100);
//    max7219.enable_device(2);
//    max7219.enable_device(2);
    max7219.enable_display();
//    max7219.set_display_test();
    wait_ms(100);
    
//    max7219.write_digit(1,1,0b00111100);
//    max7219.write_digit(1,2,0b01000010);
//    max7219.write_digit(1,3,0b10000001);
//    max7219.write_digit(1,4,0b10100101);
//    max7219.write_digit(1,5,0b10000001);
//    max7219.write_digit(1,6,0b10100101);
//    max7219.write_digit(1,7,0b01011010);
//    max7219.write_digit(1,8,0b00111100);

//    max7219.write_digit(2,1,0b00111100);
//    max7219.write_digit(2,2,0b01000010);
//    max7219.write_digit(2,3,0b10000001);
//    max7219.write_digit(2,4,0b10100101);
//    max7219.write_digit(2,5,0b10000001);
//    max7219.write_digit(2,6,0b10100101);
//    max7219.write_digit(2,7,0b01011010);
//    max7219.write_digit(2,8,0b00111100);
    
    max7219.write_digit(3,1,0b00111100);
    max7219.write_digit(3,2,0b01000010);
    max7219.write_digit(3,3,0b10000001);
    max7219.write_digit(3,4,0b10100101);
    max7219.write_digit(3,5,0b10000001);
    max7219.write_digit(3,6,0b10100101);
    max7219.write_digit(3,7,0b01011010);
    max7219.write_digit(3,8,0b00111100);
    wait_ms(2000);

    max7219.device_all_on(1);

    wait_ms(2000);

    max7219.device_all_off(1);
    wait_ms(2000);
    uint8_t number;
    
    max7219.display_all_off();
    uint8_t noOfDigits =2;
    
    while (1) {
        
//        number = 0;
//        for(col = 1; col <= numberOfDevices; col++)
//        {
//            for(row = 1; row < 9; row++)
//            {
//                max7219.write_digit(col,row,numberFont[number][row-1]);
//            }
//            number++;
//            wait_ms(2000);
//            max7219.device_all_off(col);
//        }
        printNumber(12, noOfDigits);
        wait_ms(1000);
        printNumber(345, 3);
        wait_ms(1000);
        printNumber(6789, 4);
        wait_ms(1000);
        printNumber(78, noOfDigits);
        wait_ms(1000);
        printNumber(90, noOfDigits);
        wait_ms(1000);
        
    }
}

void printNumber(uint16_t number, uint8_t noOfDigits)
{
    uint8_t right, rMiddle, lMiddle, left, col, row;
    max7219.display_all_off();
    if(noOfDigits == 2)
    {
        right = number%10;
        rMiddle = (uint8_t)(number / 10);
    }
    else if(noOfDigits == 3)
    {
        right = number%10;
        rMiddle = (uint8_t)((number%100)/10);
        lMiddle = (uint8_t)(number/100);
    }
    else if(noOfDigits == 4)
    {
        right = number%10;
        rMiddle = (uint8_t)((number%100)/10);
        lMiddle = (uint8_t)((number%1000)/100);
        left = (uint8_t)(number/1000);        
    }
    else if(noOfDigits == 1)
    {
        right = number;
    }
    
    for(col = 1; col <= noOfDigits; col++)
    {
        if(col == 1)
        {
            for(row = 1; row < 9; row++)
            {
                max7219.write_digit(col,row,numberFont[right][row-1]);
            }
            
        }
        if(col == 2)
        {
            for(row = 1; row < 9; row++)
            {
                max7219.write_digit(col,row,numberFont[rMiddle][row-1]);
            }
            
        }
        if(col == 3)
        {
            for(row = 1; row < 9; row++)
            {
                max7219.write_digit(col,row,numberFont[lMiddle][row-1]);
            }
            
        }
        if(col == 4)
        {
            for(row = 1; row < 9; row++)
            {
                max7219.write_digit(col,row,numberFont[left][row-1]);
            }
            
        }
    }
}
    
