#ifndef OBJECTS_H
#define OBJECTS_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Basket.h"
#include "Fruit.h"

/** Objects Class
@brief Class that draws objects at the top of the display then 'drops' them down
@brief the display so the player can try to catch them in the basket.

@author Nathan Johnston 
@date 14th March 2017
*/

class Objects
{
    public:
    
    Objects();
    ~Objects();
    
    //INITILISATION FUNCTION//
    
    /** Initialise Object
     *
     *   Sets speed at which objects will "fall" down the screen.
     *   Sets the y co-ordionate at which they will enter (8 by default).
     *   Randomly sets the x co-ordinate at which they will enter, which is one of
     *   7 pre-determined values.
     *   Randomly sets a value to a variable which determines the shape of the 
     *   object and the value of score assosciated with it.
     *   @param speed - "fall" speed of the object (2,3,4,5)
     */
    void init(int speed);
    
    
    //UPDATE FUNCTIONS//
    
    /** Move Object
     *
     *   Move the object down the display at a fixed value of x.
     *   @param speed - "fall" speed of the object (2,3,4,5)
     */
    void move(int speed);
    
    /** Get Score Indicator
     *
     *   Return value of the variable which determines the value of the score 
     *   assosciated with the object (1 to 5).
     */
    int get_score_var();
    
    
    //DISPLAY FUNCTIONS//
    
    /** Draw Object
     *
     *   Draw the object on the buffer by calling a draw function from Fruit
     *   using the value of the random variable set in Objects::init(int speed).
     *   @param lcd - N5110 custom library
     */
    void draw(N5110 &lcd);
    
    /** Undraw Object
     * 
     *   Draw the inverse of the object to clear it from the buffer when it 
     *   reaches a boundary by calling a draw function from Fruit
     *   using the value of the random variable set in Objects::init(int speed).
     *   @param lcd - N5110 custom library
     */
    void undraw(N5110 &lcd);
    
    /** Get Undraw indicator
     *
     *   Return value of the variable that determines which shape to undraw.
     */
    int get_undraw_var();
    
    /** Get x
     *
     *   Return the x co-ordinate of the object (3,15,27,39,51,63,75).
     */
    int get_x();
    
    /** Get y
     *
     *   Return the y co-ordinate of the object (0 to 47).
     */
    int get_y();
    
    private:
    
    //OBJECTS//
    Basket basket;
    Fruit fruit;
    
    //VARIABLES//
    int score_var;
    int undraw_var;
    int x_ref;
    int y_ref;
    int objects_ep;
    int objects_shape;
    int objects_speed;
    
};
#endif