#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Catch_Model.h"

#define BASKET_Y 41
#define BASKET_WIDTH 12
#define LIVES 5

//OBJECTS//
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);

Gamepad pad;
Catch_Model catchm;
Objects objects;
Basket basket;

int objects_speed;
int lives;

//FUNCTION PROTOTYPES//
void init();
void render();
void welcome();
void instructions_general();
void instructions_buttons();
void set_brightness();
int set_speed();

//MAIN//
int main()
{
    int fps = 8;

    init();
    welcome();
    instructions_general();
    instructions_buttons();
    set_brightness();

    while(1) {

        set_speed();//don't init game until speed is set manually
        catchm.init(BASKET_Y,BASKET_WIDTH,set_speed(),LIVES);
        //printf("game initialised\n");

        render();
        wait(1.0f/fps);

        do {
            catchm.input(pad);
            catchm.update(lcd, pad);

            catchm.check_a(lcd,pad); //game runs better if these functions are
            catchm.check_b(lcd,pad); //seperate from Catch_Model::update()

            lives = catchm.get_lives();
            
            render();
            wait(1.0f/fps); // frame rate

        } while (lives > 0);
    }
}

//FUNCTIONS//
void init()
{
    // initialise LCD and Gamepad
    lcd.init();
    pad.init();
}

void render()
{
    // re-draw screen each loop
    lcd.clear();
    catchm.draw(lcd,pad);
    lcd.refresh();
}

void welcome()
{
    lcd.printString("FRUIT BASKET",0,2);
    lcd.printString("press start",0,3);
    lcd.refresh();

    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void instructions_general()
{
    lcd.clear();
    lcd.printString("Move the",0,0); // instructions for moving basket
    lcd.printString("basket with",0,1);
    lcd.printString("L/R or the",0,2);
    lcd.printString("joystick to",0,3);
    lcd.printString("catch the",0,4);
    lcd.printString("fruit.",0,5);
    lcd.refresh();

    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void instructions_buttons()
{
    lcd.clear();
    lcd.printString("Press A for a",0,0); // A button cancels an object mid-drop
    lcd.printString("second chance.",0,1); // and immediately drops another randomly
    lcd.printString("Press B for an",0,2); // B button adds an extra life
    lcd.printString("extra life.",0,3);
    lcd.printString("Available when",0,4);
    lcd.printString("you see the",0,5);
    lcd.drawLine(69,43,73,47,1); //draw
    lcd.drawLine(73,47,77,39,1); //tick
    lcd.refresh();

    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        pad.leds_on();
        wait(0.1);
        pad.leds_off();
        wait(0.1);
    }
}

void set_brightness()
{
    lcd.clear();
    lcd.printString("Set Brightness",0,2);
    lcd.refresh();

    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        lcd.setBrightness(pad.read_pot());
        pad.leds(pad.read_pot());
    }
}

int set_speed()
{
    while (pad.check_event(Gamepad::START_PRESSED) == false) {
        lcd.clear();
        lcd.printString("Set Speed",0,2);

        if (pad.read_pot() > 0.75f) { // value of pot selects speed objects will fall at
            objects_speed = 5; // int value translates to pixels per game loop
            lcd.printString("Fast",0,3);
        } else if (pad.read_pot() > 0.5f) {
            objects_speed = 4;
            lcd.printString("Normal",0,3);
        } else if (pad.read_pot() > 0.25f) {
            objects_speed = 3;
            lcd.printString("Slow",0,3);
        } else {
            objects_speed = 2;
            lcd.printString("Very Slow",0,3);
        }

        lcd.refresh();
    }

    return objects_speed; // game initialised with this value
}