#ifndef FRUIT_H
#define FRUIT_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"

/** Fruit class
@brief Drawings of shapes that all fit in to a 6x6 grid (pixels) and are called
@brief at random by the Objects class whenever an object is initialised.

@author Nathan Johnston
@date 27th March 2017
*/

class Fruit
{
    public:
    
    Fruit();
    ~Fruit();
    
    //STRAWBERRY DRAW/UNDRAW//
    
    /** Draw Strawberry
     *
     *   Use x and y co-ordinates of an initialised object to draw a
     *   strawberry shape on the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void draw_strawberry(int x, int y, N5110 &lcd);
    
    /** Undraw Strawberry
     *
     *   Use x and y co-ordinates to draw the same shape but with
     *   FILL_WHITE rather than FILL_BLACK to effectively clear it from 
     *   the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void undraw_strawberry(int x, int y, N5110 &lcd);
    
    
    //PINEAPPLE DRAW/UNDRAW//
    
    /** Draw Pineapple
     *
     *   Use x and y co-ordinates of an initialised object to draw a
     *   pineapple shape on the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void draw_pineapple(int x, int y, N5110 &lcd)
    
    /** Undraw Pineapple
     *
     *   Use x and y co-ordinates to draw the same shape but with
     *   FILL_WHITE rather than FILL_BLACK to effectively clear it from 
     *   the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */;
    void undraw_pineapple(int x, int y, N5110 &lcd);
    
    
    //PEAR DRAW/UNDRAW//
    
    /** Draw Pear
     *
     *   Use x and y co-ordinates of an initialised object to draw a
     *   pear shape on the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void draw_pear(int x, int y, N5110 &lcd);
    
    /** Undraw Pear
     *
     *   Use x and y co-ordinates to draw the same shape but with
     *   FILL_WHITE rather than FILL_BLACK to effectively clear it from 
     *   the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void undraw_pear(int x, int y, N5110 &lcd);
    
    
    //MELON DRAW/UNDRAW//
    
    /** Draw Melon
     *
     *   Use x and y co-ordinates of an initialised object to draw a
     *   melon shape on the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void draw_melon(int x, int y, N5110 &lcd);
    
    /** Undraw Melon
     *
     *   Use x and y co-ordinates to draw the same shape but with
     *   FILL_WHITE rather than FILL_BLACK to effectively clear it from 
     *   the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void undraw_melon(int x, int y, N5110 &lcd);
    
    
    //ANTIFRUIT DRAW/UNDRAW//
    
    /** Draw Antifruit
     *
     *   Use x and y co-ordinates of an initialised object to draw an
     *   antifruit shape on the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void draw_antifruit(int x, int y, N5110 &lcd);
    
    /** Undraw Antifruit
     *
     *   Use x and y co-ordinates to draw the same shape but with
     *   FILL_WHITE rather than FILL_BLACK to effectively clear it from 
     *   the buffer.
     *   @param x - x co-ordinate reference point
     *   @param y - y co-ordinate reference point
     *   @param lcd - N5110 custom library
     */
    void undraw_antifruit(int x, int y, N5110 &lcd);
    
    private:
    //No private variables required in this class
};
#endif