#include "Basket.h"

Basket::Basket()
{
    
}

Basket::~Basket()
{
    
}
//INITILISATION FUNCTION//
//Sets x and y reference co-ordinates and sets the default score to 0
void Basket::init(int y, int width)
{
    y_ref = y;
    x_ref = WIDTH/2 - width/2; //basket will be central on display
    basket_width = width;
    score = 0;
}

//UPDATE FUNCTIONS//
//Both move functions can be used simultaneously during a game

//Move the basket with the joystick
void Basket::move_stick(Direction d, float mag)
{
    stick_speed = int(mag*9.0f); //for a full push (mag = 1) basket will move 6 pixels per loop
    
    if (d == E) { //E = right
            x_ref += stick_speed;
    } else if (d == W) { //W = left
            x_ref -= stick_speed;
    }
    
    if (x_ref < 1) { //set boundary on the left of the display
        x_ref = 1;
    }
    if (x_ref > WIDTH - basket_width - 1) { //set boundary on the right of the display
        x_ref = WIDTH - basket_width - 1;
    }
}

//Move the basket with the L and R buttons, this is supposed to be the easier option
void Basket::move_LR(Gamepad &pad)
{
    if (pad.check_event(Gamepad::R_PRESSED) == true) {
        x_ref += 12.0f; //if R is pressed move 12 pixels right (one default basket width)
    } else if (pad.check_event(Gamepad::L_PRESSED) == true) {
        x_ref -= 12.0f; //if L is pressed move 12 pixels left (one default basket width)
    }
    
    if (x_ref < 1) { //set boundary on the left of the display
        x_ref = 1;
    }
    if (x_ref > WIDTH - basket_width - 1) { //set boundary on the right of the display
        x_ref = WIDTH - basket_width - 1;
    }
}

//SCORE FUNCTIONS//
//Add different score for different objects (see Objects)

void Basket::add_score_1()
{
    score++;
}

void Basket::add_score_2()
{
    score = score + 2;
}

void Basket::add_score_5()
{
    score = score + 5;
}

void Basket::add_score_10()
{
    score = score + 10;
}

int Basket::get_score()
{
    return score;
}

//DISPLAY FUNCTIONS//
//Draw the basket and make x and y reference coordinates accessible in other libraries
  
void Basket::draw(N5110 &lcd)
{
    lcd.drawRect(x_ref,y_ref, 1, 2, FILL_BLACK);
    lcd.drawRect(x_ref + 1, y_ref + 2,1,2,FILL_BLACK);
    lcd.setPixel(x_ref + 2, y_ref + 4);
    lcd.drawRect(x_ref + 2, y_ref + 5, basket_width - 4, 1, FILL_BLACK);
    lcd.setPixel(x_ref + 9, y_ref + 4);
    lcd.drawRect(x_ref + 10, y_ref + 2, 1, 2, FILL_BLACK);
    lcd.drawRect(x_ref + 11, y_ref, 1, 2, FILL_BLACK);
}

int Basket::get_x()
{
    return x_ref;
}

int Basket::get_y()
{
    return y_ref;
}