#include "mbed.h"
#include "mDot.h"
#include "rtos.h"
#include "ChannelPlans.h"
#include "ISL29011.h"

static Serial pc(USBTX, USBRX);

I2C i2c(I2C_SDA, I2C_SCL);
ISL29011 lux(i2c);


DigitalOut led1(LED1);

void rise() {
    pc.printf("RISE\n");
    led1.write(true);
}

void fall() {
    pc.printf("FALL\n");
    led1.write(false);
}


// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {
    pc.baud(115200);

    pc.printf("Entering main()\r\n");
    
    /*GPIO_InitTypeDef GPIO_InitStruct;
    
    GPIO_InitStruct.Pin = GPIO_PIN_0;
    GPIO_InitStruct.Mode = GPIO_MODE_ANALOG;
    GPIO_InitStruct.Pull = GPIO_NOPULL;
    HAL_GPIO_Init(GPIOA, &GPIO_InitStruct);
      */  
    lux.setMode(ISL29011::ALS_CONT);
    lux.setResolution(ISL29011::ADC_16BIT);
    lux.setRange(ISL29011::RNG_64000);

    InterruptIn btn(PA_0); /* S2 - button */
    btn.rise(&rise);
    btn.fall(&fall);

    while (true) {
        pc.printf("Light: %d \r\n", lux.getData());
        //led1.write(PA_0);
        Thread::wait(1000);
        
        }
}