#include "mbed.h"

Serial pc(SERIAL_TX, SERIAL_RX);    // (TX, RX)
I2C i2c(PB_9, PB_8 );           // (SDA, SCL)
InterruptIn button(PC_13);

const int addr = 0xD0;      // 7 bit I2C address
char cmd[2];
char read_buffer[14];
char save_p[10];

int16_t acc_x = 0, acc_y = 0, acc_z = 0;
int16_t gyr_x = 0, gyr_y = 0, gyr_z = 0;
int16_t temp = 0;

float ACC_SEN = 16384.0;    //Resolución ACC
float GYR_SEN = 131.0;      //Resolución GYR
float TEM_SEN = 340.0;      //Resolución temp

float facc_x = 0, facc_y = 0, facc_z = 0;
float fgyr_x = 0, fgyr_y = 0, fgyr_z = 0;
float ftemp = 0;

double boton1; //primera interrupcion
double boton2; //segunda interrupcion

//interrupcion boton
void pressed()//sacada de codigo MIRAR FINAL DE LA PAGINA
{
    //primera interrupcion
    if(boton1==0 && boton2==0)
    {
        boton1=1;
        boton2=0;
    }   
    //segunda interrupcion
    if(boton1==2 && boton2==0)
    {
        boton1=2;
        boton2=1;
    }  
}

void datos()//funcion llamada por la primera y segunda interrupcion (comparar con la programacion orginal que envio el profe)
{
        facc_x = acc_x/ACC_SEN;
        facc_y = acc_y/ACC_SEN;
        facc_z = acc_z/ACC_SEN;     
        
        fgyr_x = gyr_x/GYR_SEN;
        fgyr_y = gyr_y/GYR_SEN;
        fgyr_z = gyr_z/GYR_SEN;

        ftemp= (temp - 521)/TEM_SEN;
}

int main()
{
    
    // Asignacion interrupcion
    button.fall(&pressed);//sacado codigo MIRAR FINAL DE LA PAGINA 
   
    pc.printf("Prueba MPU6050 \n\r");

    cmd[0] = 0x6B;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);                //Desactivar modo hibernación
    
    cmd[0] = 0x1B;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);                //gyro full scale 250 DPS

    cmd[0] = 0x1C;
    cmd[1] = 0x00;
    i2c.write(addr, cmd, 2);                //ACC fullsclae 2G

    while(1) {
        wait(1);

        cmd[0]=0x3B;
        i2c.write(addr, cmd, 1);            //Escritura del registro de inicio
        i2c.read(addr, read_buffer, 14);    //Lectura en rafaga de los valores de la MPU
        wait_ms(1);
   
       //.................Construcción de la medición de los valores .................. 
             
        acc_x = read_buffer[0]<<8 | read_buffer[1];    
        acc_y = read_buffer[2]<<8 | read_buffer[3];
        acc_z = read_buffer[4]<<8 | read_buffer[5];
        temp  = read_buffer[6]<<8 | read_buffer[7];
        gyr_x = read_buffer[8]<<8 | read_buffer[9];
        gyr_y = read_buffer[10]<<8 | read_buffer[11];
        gyr_z = read_buffer[12]<<8 | read_buffer[13];
        
        //primera interrupcion       
        while(boton1==1 && boton2==0)//datos dados por la primera interrupcion
        {
        datos();
        pc.printf("primer rafaga de datos");
        wait(2);//para que se visualice el titulo de la rafaga y no pase tan rapido
        float j=0;  //lo deje float porque si lo dejo entero en el momento de imprimir me sale unicamente cero y la deje local para evitar gasto de memoria
        for(int i=0;i<=99;i++)//100 datos
        {
        j++;//numero de dato en incremento
        pc.printf("dato %.2f \n\r", j); //impresion del numero del dato  
        pc.printf("ACCx   ACCy   ACCz   GYRx   GYRy   GYRz   Temp   \n\r");
        pc.printf("%.2f   %.2f   %.2f   %.2f   %.2f   %.2f   %.2f   \n\r", facc_x, facc_y, facc_z, fgyr_x, fgyr_y, fgyr_z, ftemp);
        pc.printf("\n\r");
        }
        //iniciacion para la segunda rafaga de datos
        boton1=2;
        boton2=0;// se deja cero para que entre a la segunda rafaga de datos EN LA INTERRUPCION
        }
        
        //segunda interrupcion
        while(boton1==2 && boton2==1)//datos dados por la segunda interrupcion
        {
        datos();    
        pc.printf("segunda rafaga de datos");
        wait (2);//para que se visualice el titulo de la rafaga y no pase tan rapido
        float j=0;//lo deje float porque si lo dejo entero en el momento de imprimir me sale unicamente cero y la deje local para evitar gasto de memoria 
        
        for(int i=0;i<=499;i++)//500 datos
        {
        j++; //numero de dato en incremento   
        pc.printf("dato %.2f \n\r", j);   //impresion del numero del dato
        pc.printf("ACCx   ACCy   ACCz   GYRx   GYRy   GYRz   Temp   \n\r");
        pc.printf("%.2f   %.2f   %.2f   %.2f   %.2f   %.2f   %.2f   \n\r", facc_x, facc_y, facc_z, fgyr_x, fgyr_y, fgyr_z, ftemp);
        pc.printf("\n\r");
        }
        boton1=0;
        boton2=0;// se deja cero para que entre a la primera rafaga de datos EN LA INTERRUPCION,
        // es decir la proxima vez que oprima no va a ser necesario que vuelva a iniciar el programa sino que directamente entra 
        //a la primera rafaga de datos
        }
  }
}

/*EJEMPLO INTERRUPCION BOTON
#include "mbed.h"

InterruptIn button(USER_BUTTON);

DigitalOut led(LED1);

double delay = 0.5; // 500 ms

void pressed()
{
    delay = 0.1; // 100 ms
}

void released()
{
    delay = 0.5; // 500 ms
}

int main()
{
    // Assign functions to button
    button.fall(&pressed);
    button.rise(&released);

    while (1) {
        led = !led;
        wait(delay);
    }
}
*/