#include "mbed.h"
#include "ADXL345.h"
#include "MPL115A2.h"
#include "SDFileSystem.h"

ADXL345 accelerometer(p11, p12, p13, p9);
MPL115A2 mpl115a2(p28, p27);
SDFileSystem sd(p5, p6, p7, p8, "sd");
Serial pc(USBTX, USBRX);
AnalogIn temp_in(p20);
AnalogIn Gyrox(p15);
AnalogIn Gyroy(p16);
AnalogIn hiG(p17);
Ticker logger;
DigitalOut ping(p17);
DigitalOut myled(LED1);

int readings[3] = {0,0,0};
float pressure;
char pres_data[16];
float temp1;
float temp2;

volatile int cnt=0;

volatile int cntt=0;

int i,j,k=0;
void logging(){
    myled=1;
    FILE *fp = fopen("/sd/datalog/log.txt","a");
    if(fp == NULL){
        error("Could not open file for write\n");
    }
    cnt++;
    accelerometer.getOutput(readings);
    fprintf(fp,"%d,%i,%i,%i,%4.2f,%3.2f,%f,%f,%f\n",cnt,(int16_t)readings[0], (int16_t)readings[1], (int16_t)readings[2],  mpl115a2.readPressure(),(float)temp_in.read()*3.3*100,(float)Gyrox,(float)Gyroy,(float)hiG);
    fclose(fp);
    myled=0;
}

int main(){
    accelerometer.setPowerControl(0x00);
    accelerometer.setDataFormatControl(0x0B);
    accelerometer.setDataRate(ADXL345_3200HZ);
    accelerometer.setPowerControl(0x08);

    mkdir("/sd/datalog",0777);
    
    logger.attach(&logging,0.05);
    k=0; 
    while(1){
    }
}