//sd card define
#define CM1K        0x01

#define MAX_SIZE    100


 



//register address
#define NM_NCR          0x00    // Neuron Context Register
#define NM_COMP         0x01    // Component
#define NM_LCOMP        0x02    // Last Component
#define NM_DIST         0x03    // Distance register, between [0, 65535]
#define NM_IDX          0x03    // 
#define NM_CAT          0x04    // Category register
#define NM_AIF          0x05    // Active Influence Field
#define NM_MINIF        0x06    // Minumum Influence Field
#define NM_MAXIF        0x07    // Maximum Influence Field
#define NM_TESTCOMP     0x08    // 
#define NM_TESTCAT      0x09    // 
#define NM_NID          0x0A    // Neuron Identifier or index of the neuron in the chain, Bit[15:0]= 2 lower bytes of a 3-bytes neuron identifier.
#define NM_GCR          0x0B    // Global Context and also partial identifier of the RTL neuron
#define NM_RSTCHAIN     0x0C    // 
#define NM_NSR          0x0D    // Network Status Register
#define NM_POWER_SAVE   0x0E
#define NM_NCOUNT       0x0F    // Count of committed neurons, Bit[15:0]= 2 lower bytes of the count
#define NM_FORGET       0x0F    // Uncommit all neurons by clearing their category register.

//#define NEURONSIZE  256 //memory capacity of each neuron in byte
//#define MAXNEURONS  1024 //(576*2) //number of neurons per chip

#define NEURONSIZE  256 //memory capacity of each neuron in byte
#define MAXNEURONS  576*1 //(576*2) //number of neurons per chip

#define LOW         0
#define HIGH        1

#define WRITE       0
#define READ        1







extern int begin();
extern void forget();
extern int clearNeurons();
extern int learn(unsigned char vector[], int length, int category);
//extern int classify(unsigned char vector[], int length, int K, int distance[], int category[], int nid[]);
extern int classify(unsigned char vector[], int length, int* distance, int* category, int* nid);
extern void setContext(int context, int minif, int maxif);
extern void getContext(int* context, int* minif, int* maxif);
extern void setRBF();
extern void setKNN();
extern int NCOUNT();

extern void write(char reg, int data);
extern int read(char reg);
extern int broadcast(unsigned char vector[], int length);
extern void readNeuron(int nid, unsigned char model[], int* context, int* aif, int* category);
extern void SPI_Init(void);
extern void RESET_Test(void);






