#include "NM500.h"
#include "mbed.h"
//#include "SDFileSystem.h"

//SDFileSystem sd(SD_MOSI, SD_MISO, SD_SCK, SD_CS, "sd"); // the pinout on the mbed Cool Components workshop board

SPI NM500(SPI_MOSI, SPI_MISO, SPI_SCK);

//Serial test(SERIAL_TX, SERIAL_RX);
//extern int Reset_fail;
//extern int CMN_RC;
//extern int aif_fail;
//extern int ncount_fail;
//extern int Gcr1;
//extern int Gcr2;
//extern int Aif1;
//extern int Aif2;
//extern int Minif1;
//extern int Minif2;
//extern int Maxif1;
//extern int Maxif2;
//extern int Cat1;
//extern int Cat2;
//
//extern int Memory1;
//extern int Memory2;
//
//extern char array1[NEURONSIZE];
//extern char array2[NEURONSIZE];


//FILE *fp=NULL;

DigitalOut BC_CS(D9);
//DigitalOut SDCard_CS(D10);
//DigitalOut CLK_EN(PA_15);

//SPI init
void SPI_Init(void)
{    

    BC_CS = HIGH;       //disable
  
    NM500.format(8,0);
    NM500.frequency(1000000);
    printf("SPI Init OK\n");



}
int begin()
{
    return clearNeurons();     //neruon init()
}
//void RESET_Test(void)
//{
//    int nsr = read(NM_NSR);
//    int gcr = read(NM_GCR);
//    int minif = read(NM_MINIF);
//    int maxif = read(NM_MAXIF);  
//
//    printf("RESET Test\n");
//    
//    if(nsr != 0x00)
//        Reset_fail = 1;
//    if(gcr != 0x01)
//        Reset_fail = 1;
//    if(minif != 0x02)
//        Reset_fail = 1;
//    if(maxif != 0x4000)
//        Reset_fail = 1;
// 
//    if(Reset_fail == 0)
//        printf("Reset Test Pass\n");
//    else
//        error("Reset the NM500 and proceed");
////    printf("NSR : 0x%x\n", nsr);
////    printf("GCR : 0x%x\n", gcr);
////    printf("MINIF : 0x%x\n", minif);
////    printf("MAXIF : 0x%x\n", maxif);
//
//    
//}
//forget
void forget()
{
    write(NM_FORGET, 0);
}
int clearNeurons()
{
    write(NM_FORGET,0);
    write(NM_NSR, 0x10);
    for (int i=0; i< NEURONSIZE; i++) write(NM_TESTCOMP,0);
    write(NM_NSR, 0);
    
    if(read(NM_MINIF)==2)
        return(0);      //clear ok
    else
        return(1);      //clear error
        
}
int learn(unsigned char vector[], int length, int category)
{
    broadcast(vector, length);
    write(NM_CAT,category);
    return(read(NM_NCOUNT));
}

int classify(unsigned char vector[], int length, int* distance, int* category, int* nid)
{
    broadcast(vector, length);
    *distance = read(NM_DIST);
    *category = read(NM_CAT) & 0x7FFF; //Degenerated bit15 is masked
    *nid = read(NM_NID);

    return(read(NM_NSR));
}

void setRBF()
{
    int tempNSR=read(NM_NSR);
    write(NM_NSR, tempNSR & 0xDF);
}
void setKNN()
{
    int tempNSR = read(NM_NSR);
    write(NM_NSR, tempNSR | 0x20);
}

//Read the selected neuron data.
int NCOUNT()
{
    return(read(NM_NCOUNT));
}


//write data
void write(char reg, int data)
{
    NM500.format(8,0);
    BC_CS = LOW;
    NM500.write(1);      //dummy
    NM500.write(CM1K+0x80);
    NM500.write(0);
    NM500.write(0);
    NM500.write(reg);
    NM500.write(0);
    NM500.write(0);
    NM500.write(1);
    NM500.write((unsigned char)(data >> 8)); // upper data
    NM500.write((unsigned char)(data & 0x00FF)); // lower data
    //for(int i=0;i<10;i++);
    BC_CS = HIGH;


}

//read data
int read(char reg)
{
    NM500.format(8,0);
    BC_CS = LOW;        //BC enable

    NM500.write(1);      //dummy
    NM500.write(CM1K);
    NM500.write(0);
    NM500.write(0);
    NM500.write(reg);
    NM500.write(0);
    NM500.write(0);
    NM500.write(1);
    int data = NM500.write(0); // Send 0 to push upper data out
    data = (data << 8) + NM500.write(0); // Send 0 to push lower data out
    BC_CS = HIGH;
    return(data);
}
int broadcast(unsigned char vector[], int length)
{
    for(int i=0; i<length-1; i++)
        write(NM_COMP,vector[i]);
    write(NM_LCOMP, vector[length-1]);

    return read(NM_NSR);
}
 
//int NeuronToSD()
//{
//
//    char neurons[NEURONSIZE];
//    int aif=0;
//    fp = fopen("/sd/data.txt", "w");
//    if(fp == NULL)
//        error("Write SD Fail");
//    fflush(stdin);
//    
//    //save NSR
//    int TempNSR = read(NM_NSR);
// 
//    //read NCOUNT
//    int nm_cnt = read(NM_NCOUNT);
//    if(nm_cnt == 0xFFFF || nm_cnt == 0x7FFF)     //change
//        nm_cnt = MAXNEURONS;
//    //printf("NCOUNT : %d\n", nm_cnt);
//
//    
//    //write NSR-SR Mode
//    write(NM_NSR, 0x10);   
//    
//    //reset chain
//    write(NM_RSTCHAIN, 0);
//    
//    //loop until max neruon
//    for(int cnt = 1; cnt<=nm_cnt; cnt++){  
//        
//        //read context
//        int context = read(NM_NCR);
//       //printf("context #%d\t,", context);
//        fprintf(fp,"%d\t", context);
//        
//        //GCR register fail
//        if(context != 5){   
//            if(cnt < MAXNEURONS/2){ //neuron1 fail
//                Gcr1=1;
//                printf("\nNID # %d, GCR # %d \n",cnt,context);
//            }
//            else{                   //neruon2 fail
//                Gcr2=1;
//                printf("\nNID # %d, GCR # %d \n",cnt,context);
//            }
//        }
//        char temp_neuron[NEURONSIZE];
////        for(int j =0;j<NEURONSIZE;j=j+2){   
////            temp_neuron[j] = cnt>>8;          //upper bit save
////            temp_neuron[j+1] = cnt;           //low bit save
////        }
//        if(cnt%2 == 1){
//            for(int j =0;j<DATA_CNT;j=j+2){   
//                temp_neuron[j] = cnt>>8;          //upper bit save
//                temp_neuron[j+1] = cnt;           //low bit save
//            }
//            for(int j =DATA_CNT;j<NEURONSIZE; j++){   
//                temp_neuron[j] = array1[j];          //upper bit save
//            }
//        }
//        else if(cnt%2 == 0){
//            for(int j =0;j<DATA_CNT;j=j+2){   
//                temp_neuron[j] = cnt>>8;          //upper bit save
//                temp_neuron[j+1] = cnt;           //low bit save
//            }
//            for(int j =DATA_CNT;j<NEURONSIZE; j++){   
//                temp_neuron[j] = array2[j];          //upper bit save
//            }
//        }    
//       //printf("Neruon Data : ");       
//        //read Neuron data
//        for (int j=0; j<NEURONSIZE; j++){
//            //read COMP 
//            neurons[j]=read(NM_COMP);
//            fprintf(fp,"%d,", neurons[j]);
//            //printf("%d,", neurons[j]);
//            if(temp_neuron[j]!= neurons[j]){
//                
//                if(j<MAXNEURONS/2){
//                    printf("NID # %d Memory Fail\n", cnt);
//                    Memory1 = 1;
//                }
//                else{
//                    printf("NID # %d Memory Fail\n", cnt);
//                    Memory2 = 1;
//                }
//                printf("# %d : temp %d, neruon %d\n",j, temp_neuron[j],neurons[j]);
//                    
//            }
//                
//        }
//
//
//        
//        //read AIF
//        aif=read(NM_AIF);
//        fprintf(fp,"\t%d\t", aif);
//        //printf("AIF : %d,\t", aif);
//        
//        //aif register fail
//        if(aif != 5){
//            if(cnt <= 576){ //neuron1 fail
//                Aif1=1;
//                printf("\nNID # %d, AIF # %d \n",cnt,aif);
//            }
//            else{                   //neruon2 fail
//                Aif2=1;
//                printf("\nNID # %d, AIF # %d \n",cnt,aif);
//            }
//        }      
//        
//        //raed minif
//        int minif=read(NM_MINIF);
//        //printf("MINIF : %d,\t", minif);
//        fprintf(fp,"%d\t", minif);
//        
//        //minif register fail
//        if(minif != 3){
//            if(cnt <= 576){ //neuron1 fail
//                Minif1 = 1;
//                printf("\nNID # %d, MINIF # %d \n",cnt,minif);
//            }
//            else{                   //neruon2 fail
//                Minif2 = 1;
//                printf("\nNID # %d, MINIF # %d \n",cnt,minif);
//            }
//        }
//        
//        //read cat
//        int cat = read(NM_CAT) & 0x7FFF;
//        fprintf(fp,"%d\t", cat);      
//        fprintf(fp,"\n");
//        //printf("****CAT : %d\n", cat);
//        
//        //reset chain test
////        if(cnt > 2 && cat == 1)
////            CMN_RC = 1;
//            
//        //cat test
//        if(cnt != cat){
//            printf("cnt : %d , cat : %d \n", cnt, cat);
//            if(cnt <= 576){
//                Cat1 = 1;
//                printf("\n NM500 #1 Cat Fail # %d\n", cnt);
//            }
//            else {
//                Cat2 = 1;
//                printf("\n NM500 #2 Cat Fail # %d\n", cnt);
//            }
//        }
//        printf(".");
//    }
//    printf("\n");
//        
// 
//    fclose(fp);
//    write(NM_NSR, TempNSR); // set the NN back to its calling status
//    return read(NM_NCOUNT);
//}
//
//
//int SDToNeurons()
//{
//    int context,aif,minif,cat;
//    char neurons[NEURONSIZE];
//    fp = fopen("/sd/data.txt", "r");
//    
//
//    if(fp == NULL)
//        error("Read SD Fail");
//
//    //save NSR
//    int TempNSR = read(NM_NSR);
//    
//    //write NSR-SR Mode
//    write(NM_NSR, 0x10);   
//    
//    //reset chain
//    write(NM_RSTCHAIN, 0);
//           
//    //SD data read -> Neurons   
//    for(int i=1;i<=MAXNEURONS;i++){
//        //read context
//        fscanf(fp,"%d", &context);
//      // printf("context # %d ", context);
//        write(NM_GCR,context);
//        
//        
//        //read comp
//        for (int j=0; j<NEURONSIZE; j++){
//            //read COMP 
//            fscanf(fp,"%d,", &neurons[j]);
//          // printf("%d\t,", neurons[j]);
//            write(NM_COMP,neurons[j]);
//        }
//        fscanf(fp,"\t%d\t", &aif);
//      // printf("AIF # %d \t", aif);
//        write(NM_AIF,aif);
//
//        fscanf(fp,"%d\t", &minif);
//      // printf("MINIF # %d", minif);
//        write(NM_MINIF,minif);    
//        
//        fscanf(fp,"%d\t", &cat);
//     //  printf("CAT # %d \n", cat);
//        write(NM_CAT,cat);
//        printf(".");
//        
//    }
//    printf("\n");
//    fclose(fp);
//    write(NM_NSR, TempNSR); // set the NN back to its calling status
//    return NCOUNT();
//}



