
#include "mbed.h"
#include "rtos.h"
#include "Lora.h"
#include "Beacon.h"

#define LORA_SEND_THREAD "lora_send_thread"
#define HEART_BEAT_PACKET_SENDING   0x01
#define STATUS_PACKET_SENDING       0x02

InterruptIn checkinIntr(PC_13);
InterruptIn motionIntr(PB_14);
InterruptIn testIntr(PB_5);


DigitalOut led1(LED1);
DigitalOut led2(PA_11);
DigitalOut led3(PA_12); 

/* reserve the debbuger uart to shell interface */
Serial pc_serial(USBTX,USBRX);
 RawSerial pc3(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10
 RawSerial LORA_UART(PA_0, PA_1);//USART4_TX->PA_0,USART4_RX->PA_1      :       Used for Lora module command sending and reception from gateway
//RawSerial pc1(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10   :       Used for debugging purpose only
//RawSerial DEBUG_UART(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10   :       Used for debugging purpose only
RawSerial Beacon_UART(PC_4, PC_5);//USART3_TX->PC4,USART3_RX->PC_5     :       Used for sending command to beacon module
RawSerial BLE_RECEIVER_UART(PA_9, PA_10);//USART1_TX->PA_0,USART1_RX->PA_1      :       Used for Lora module command sending and reception from gateway
Serial pc1(USBTX, USBRX);
RawSerial DEBUG_UART(USBTX, USBRX);//USART1_TX->PA_9,USART1_RX->PA_10   :       Used for debugging purpose only

/* declares threads for this demo: */
const size_t a_stk_size = 384;
uint8_t a_stk[a_stk_size];
Thread loraSendThread(osPriorityNormal, a_stk_size, &a_stk[0]);

const size_t c_stk_size = 384;
uint8_t c_stk[c_stk_size];

const size_t e_stk_size = 384;
uint8_t e_stk[e_stk_size];
Thread checkinEventThread(osPriorityNormal, e_stk_size, &e_stk[0]);
Thread motionEventThread(osPriorityNormal, c_stk_size, &c_stk[0]);

// create an event queue
EventQueue chechinEventQueue;
EventQueue motionEventQueue;

Queue<int, 16> loraQueue;
int message2;
int message3;
 
uint32_t count = 0;

//Datatype typecasting
typedef unsigned char uint8;
typedef unsigned int uint16;

uint8 OBD_Plug_In_Status = FALSE;

//peripheral connection
//DigitalOut led1(PB_11);
//DigitalOut led2(LED2);
DigitalIn Switch2(PB_13);


//InterruptIn OBD_PLUGIN_INTERRUPT_PIN(PC_13);
InterruptIn CheckIn_Interrupt(PB_7);//(PC_13);
InterruptIn Motion_Start_To_Stop(PB_5);//(PC_13);
InterruptIn Motion_Stop_To_Start(PB_14);//(PC_13);
InterruptIn Motion_Sudden_Jerk(PC_13);//(PC_13);


uint8 Ticker_Count = 0;    //Variable to count for timer overflows

uint8 OBD_Plugin_Detected = FALSE;

//Create Object for structure of Lora Packet to be sent

static uint16 Calculate_Wheels_RPM(uint8* Buffer);
void flip_Packet_Sending_Flag();
void Lora_Periodic_Packet_Sending_thread(void const *args);

void Lora_Rcvd_Cmd_Processing_thread(void);// const *args);
void Enable_CheckIN_Packet_Sending();

const char GET_RSSI[]= {0x41,0x54,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x0A};
const char SET_BEACON_VENDOR_ID[]= {0x41,0x54,0xF1,0x01,0x02,0x00,0x00,0x00,0x00,0xF2,0x0D,0x0A};
const char SET_BEACON_MESSAGE_TYPE[]= {0x41,0x54,0xF2,0x01,0x00,0x00,0x00,0x00,0x00,0xF3,0x0D,0x0A};
/*************************Accelerometer related definitions***********************************/
//Accelerometer related definitions

#define DOUBLE_TAP_INTERRUPT        0x20
#define ACTIVITY_INTERRUPT          0x10
#define INACTIVITY_INTERRUPT        0x08

#define TAP_THRESHOLD               75
#define ACTIVITY_THRESHOLD          64      // THRES_ACT register value 62.5mg/LSB , therfore value 32 indicates 2g activity
#define INACTIVITY_THRESHOLD        50

#define DUR_TIME                    0x15    // DUR Register value providing maximum time to be held to generate an interrupt
#define LATENT_TIME                 0x15    // The interrupt latency
#define WINDOW_TIME                 0x45    // The time of the interrupt window in which the next tap will be detected 
#define INACTIVITY_VALIDATION_TIME  5       // The time until which the acceleration must be held below the inactivity threshold to generate an inactvity interrupt
// Here the value 5 indicates literally 5 secs
#define X_AXIS_OFFSET               0x7F
#define Y_AXIS_OFFSET               0x7F
#define Z_AXIS_OFFSET               0x05

Serial pc(USBTX, USBRX);
I2C i2c(PB_9, PB_8);

InterruptIn activity(PB_0);
InterruptIn inactivity(PA_4); // As for now only this is used
DigitalOut led(LED1);

const int slave_address_acc = 0xA6;
char axis_data[6] = {0,0,0,0,0,0};

char interrupt_source[2];
char axis_data_start_address[2] = {0x32, 0};
char intr_source_address[2] = {0x30, 0};
char all_interrupt_clear_command[2] = {0x2E, 0x00};
char all_interrupt_enable_command[2] = {0x2E, 0x38};
char activity_interrupt_disable_command[2] = {0x2E, 0x08};
char inactivity_interrupt_disable_command[2] = {0x2E, 0x30};
char accelerometer_status_registered = 0;
unsigned int interrupt_source_duplicate;

char threshold_offset_command[5];
char act_inact_time_config_command[8];
char interrupt_enable_command[3];
char tap_axis_enable_command[2];
char baud_rate_command[2];
char data_format_command[2];
char measure_bit_on_command[2];


unsigned char vehicle_speed = 25;                                       // Kmph
unsigned char current_speed, previous_speed, speed_threshold = 10;      // Kmph

unsigned char x_axis, y_axis, z_axis;

unsigned char Motion_Detect_Status = FALSE;
uint8 OBD_PlugInOut_IOC_Status = FALSE;
unsigned char Motion_Type_Detected = 0x00;//MOTION_TYPE_UNKNOWN;    //By default set motion type as unknown
void Accelerometer_Process_thread();//void const *args) ;

/************************************************************************/

uint8 Command_Length_Sent;
uint8 Checkin_Detect_Status = FALSE;
void Extract_Received_Lora_Response(void);
void Send_Command_To_BLE_Receiver(const char* Command);

char previous_state = 0;
char current_state = 0;

uint8 OBD_PlugIN_State=0;
uint8 OBD_PlugIN_State1=0;
uint8 OBD_PlugIN_State2=0;
uint8 OBD_PlugIN_Temp_State=1;

uint8 Start_To_Stop_Status = FALSE;
uint8 Stop_To_Start_Status = FALSE;
uint8 Jerk_Status = FALSE;
#define BLE_RECEIVER_UART_RX_Size 100
uint8 BLE_RxBuffer_End_Pos = 0;
char BLE_Receiver_UART_RX_Buffer[BLE_RECEIVER_UART_RX_Size];

void Start_To_Stop_Interrupt()
{
    Start_To_Stop_Status = TRUE;
    Motion_Detect_Status = TRUE;
}

void Stop_To_Start_Interrupt()
{
    Stop_To_Start_Status = TRUE;
    Motion_Detect_Status = TRUE;
}

void Sudden_Jerk_Interrupt()
{
    Jerk_Status = TRUE;
    Motion_Detect_Status = TRUE;
}
/*
void OBD_Plug_IN_Interrupt()
{
    if(OBD_PlugIN_State1!=OBD_PlugIN_Temp_State) {
        OBD_PlugIN_State1=1;
        OBD_PlugIN_State=!OBD_PlugIN_State;
        OBD_PlugIN_Temp_State=OBD_PlugIN_State;
        OBD_PlugInOut_IOC_Status = TRUE;
    }
}

void OBD_Plug_OUT_Interrupt()
{
    
    if(OBD_PlugIN_State2!=OBD_PlugIN_Temp_State) {
        OBD_PlugIN_State2=0;
        OBD_PlugIN_State=!OBD_PlugIN_State;
        OBD_PlugIN_Temp_State=OBD_PlugIN_State;
        OBD_PlugInOut_IOC_Status = TRUE;
    }
}

//This function is Interrupt routine for detecting OBD Plugin and Out
void Handle_CheckIn_Interrupt()
{
    OBD_PlugInOut_IOC_Status = TRUE;
    pc.printf("\nMovement_Detected\n");
}

//Declare Ticker for sending lora packet
Ticker Lora_Packet_Sending_Ticker;
void flip_Packet_Sending_Flag(void)
{
    led1=!led1;
    //flip function
    if(Ticker_Count < 5) {
        Ticker_Count++;
    } else {
        Ticker_Count = 0;
        Send_Lora_Packet_Flag = TRUE;
    }
}
*/
// called every time a byte is received from lora module.
void Lora_onDataRx()
{
    while (LORA_UART.readable()) {
        // while there is data waiting
        LORA_UART_RX_Buffer[Lora_RxBuffer_End_Pos++] = LORA_UART.getc(); // put it in the buffer
        //pc1.putc(LORA_UART_RX_Buffer[Lora_RxBuffer_End_Pos-1]);
        if(Lora_RxBuffer_End_Pos >= LORA_UART_RX_Size) {
            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
            // For now just throw everything away.
            Lora_RxBuffer_End_Pos  = 0;
        }
    }
}
/*
// called every time a byte is received from Beacon Module.
void Beacon_onDataRx()
{
    while (Beacon_UART.readable()) {
        // while there is data waiting
        Beacon_RX_Buffer[Beacon_RxBuffer_End_Pos++] = Beacon_UART.getc(); // put it in the buffer
        pc1.printf("%2x",Beacon_RX_Buffer[Beacon_RxBuffer_End_Pos-1]);
        if(Beacon_RxBuffer_End_Pos >= 100) {
            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
            // For now just throw everything away.
            Beacon_RxBuffer_End_Pos  = 0;
        }
    }
}

void BLE_Receiver_onDataRx(void)
{
    while (BLE_RECEIVER_UART.readable()) {
        // while there is data waiting
        //BLE_Receiver_UART_RX_Buffer[BLE_RxBuffer_End_Pos++] = BLE_RECEIVER_UART.getc(); // put it in the buffer
        //pc1.putc(BLE_Receiver_UART_RX_Buffer[BLE_RxBuffer_End_Pos-1]);
        if(BLE_RxBuffer_End_Pos >= BLE_RECEIVER_UART_RX_Size) {
            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
            // For now just throw everything away.
            BLE_RxBuffer_End_Pos  = 0;
        }
    }
}
*/

void checkinFunction() {
  // this now runs in the context of checkinEventThread, instead of in the ISR
  count++;
  printf("Toggling LED 2!\r\n");
  for(int i = 0 ; i < 0xFFFFFF; i++);
  led2 = !led2;
  message2 = 1;
  loraQueue.put(&message2);
  printf("Toggled LED 2 count = %d \r\n", count);
}

void motionFunction() {
  // this now runs in the context of motionEventThread, instead of in the ISR
  count++;
  printf("Toggling LED 3!\r\n");
  for(int i = 0 ; i < 0xFFFFFF; i++);
  led3 = !led3;
  message3 = 2;
  loraQueue.put(&message3);
  printf("Toggled LED 3 count = %d \r\n", count);
}

/**
 * @brief thread a function 
 */
static void loraSendThreadFunc(void const *buf)
{
    uint32_t execs = 0;
    int *message1;
    osEvent evt;
    pc_serial.printf("## started %s execution! ##\n\r", (char *)buf);
 
    for(;;) {
        execs++;
        /* adds dummy processing */
        for(int i = 0 ; i < 0xFFFFFF; i++);
        evt = loraQueue.get();
        if (evt.status == osEventMessage) {
           message1 = (int*)evt.value.p;
        }
        if( *message1 == HEART_BEAT_PACKET_SENDING)
           Send_HeartBeat_Packet();                            //call function to send heartbeat packet
        else if( *message1 == STATUS_PACKET_SENDING)
           Send_Vehicle_Status_Packet();                            //call function to send heartbeat packet
        pc_serial.printf("## %s executed %d times! p = %d ##\n\r", (char *)buf, execs, *message1);
        led1 = !led1;
        Thread::yield();
    }
}

/**
 * @brief main application loop
 */
int main(void) 
{        
    pc_serial.baud(115200);
    pc3.baud(115200);
    pc_serial.printf("Hello");
    LORA_UART.attach(&Lora_onDataRx, Serial::RxIrq);
    Set_Up_Lora_Network_Configuration();
    Initialize_lora_Packets();
    loraSendThread.start(callback(loraSendThreadFunc, (void *)LORA_SEND_THREAD));
    //b_thread.start(callback(thread2, (void *)THREAD_B));
    /*c_thread.start(callback(thread3, (void *)THREAD_C));*/
    
    checkinEventThread.start(callback(&chechinEventQueue, &EventQueue::dispatch_forever));
    motionEventThread.start(callback(&motionEventQueue, &EventQueue::dispatch_forever));
 
    // wrap calls in queue.event to automatically defer to the queue's thread
    checkinIntr.fall(chechinEventQueue.event(&checkinFunction));
    motionIntr.fall(motionEventQueue.event(&motionFunction));
    
    return 0;
}


