 #include "mbed.h"
 #include "Common_Defs.h"
 
 // mDOT AT COMMANDS DEFINITIONS
 #define ENABLED         1
 #define Disabled        0
 #define NWK_PARA_HEX    0
 #define NWK_PARA_STRING 1
 #define LORA_UART_RX_Size 2000//Buffer for receiving Lora responses
 
 #define LORA_PACKET_HEADER         0xFE           //Lora Header,SOF,Every packet sent starts with 0xFE
 
 #define HEART_BEAT_PACKET_CMD      0x01           //MSB,HeartBeat Identification Packet
 #define CHECKIN_PACKET_CMD         0x02           //MSB,CheckIn Identification Packet
 #define CHECKOUT_PACKET_CMD        0x03           //MSB,CheckIn Identification Packet
 #define MOTION_PACKET_CMD          0x04           //MSB,Motion Identification Packet
 #define STATUS_PACKET_CMD          0x05           //MSB,Status Packet
 #define NEW_DEV_PACKET_CMD         0x06           //MSB,New Device Identification Packet


 //Lora Frequency SubBand
 #define FREQUENCY_SUB_BAND_CHANNEL0  0
 #define FREQUENCY_SUB_BAND_CHANNEL1  1
 #define FREQUENCY_SUB_BAND_CHANNEL2  2
 #define FREQUENCY_SUB_BAND_CHANNEL3  3
 #define FREQUENCY_SUB_BAND_CHANNEL4  4
 #define FREQUENCY_SUB_BAND_CHANNEL5  5
 #define FREQUENCY_SUB_BAND_CHANNEL6  6
 #define FREQUENCY_SUB_BAND_CHANNEL7  7
 #define FREQUENCY_SUB_BAND_CHANNEL8  8
 
 #define HEX_PARAMETER                  0
 #define STRING_PARAMETER               1
 
 //Network Join Status
 #define NETWORK_STATUS_JOINED          1
 #define NETWORK_STATUS_NOT_JOINED      0
 
 //Netwrork Join Retries Definitions
 #define NETWORK_JOIN_RETRIES_Disable   0
 #define NETWORK_JOIN_RETRIES_1         1
 #define NETWORK_JOIN_RETRIES_2         2
 #define NETWORK_JOIN_RETRIES_3         3
 #define NETWORK_JOIN_RETRIES_4         4

 #define HEARTBEAT_TYPE_PACKET   0x01
 #define MOTION_TYPE_PACKET      0x02
 #define CHECKIN_TYPE_PACKET     0x03
 #define STATUS_TYPE_PACKET      0x04
 
 
 extern uint8 Packet_Type_To_Send;  //By Default Heart Beat PAckets should be sent


struct Fixed_Beacon
{
    uint8 Parking1_Beacon_ID[6];
    uint8 Parking1_Beacon_Signal_Strength;
    uint8 Parking2_Beacon_ID[6];
    uint8 Parking2_Beacon_Signal_Strength;  
    uint8 Parking3_Beacon_ID[6];
    uint8 Parking3_Beacon_Signal_Strength;
};

struct Near_Car_Beacon
{
    uint8 Near_Car1_Beacon_ID[6];
    uint8 Near_Car1_Beacon_Signal_Strength;
    uint8 Near_Car2_Beacon_ID[6];
    uint8 Near_Car2_Beacon_Signal_Strength;  
    uint8 Near_Car3_Beacon_ID[6];
    uint8 Near_Car3_Beacon_Signal_Strength;
};

struct Misc_Packets
{
    uint8 Header;
    uint8 Protocol_Version;
    uint16 OBD_Battery_Voltage;
    uint16 Car_Battery_Voltage;
    uint8 OBD_Battery_Temperature;
    uint8 Car_Ambient_Temperature;
    uint8 VIN[17];                  //Vehicle Identification Number
    uint8 ODO_METER_READING[3];
};

struct Heart_Beat_PacketType
{
    Misc_Packets Misc_Packet_Data;
    uint8 Packet_Type;
    Fixed_Beacon Fixed_Beacon_Packet;
    uint8 Sequence_No;
    uint8 FCS;
};

struct Vehicle_Status_PacketType
{
    Misc_Packets Misc_Packet_Data;
    uint8 Packet_Type;
    uint16 Fuel_Level;
    uint8 BLE_Adv_Beacon_ID[6];
    Fixed_Beacon Fixed_Beacon_Packet;
    Near_Car_Beacon Near_Car_Beacon_Packet;
    uint8 Sequence_No;
    uint8 FCS;
};

struct CheckIN_PacketType
{
    Misc_Packets Misc_Packet_Data;
    uint8 Packet_Type;
    uint8 DTC[5];   //Diagnostic trouble code
    Fixed_Beacon Fixed_Beacon_Packet;
    uint8 Sequence_No;
    uint8 FCS;
};

struct CheckOUT_PacketType
{
    Misc_Packets Misc_Packet_Data;
    uint8 Packet_Type;
    uint8 Sequence_No;
    uint8 FCS;
};

struct Motion_PacketType
{
    Misc_Packets Misc_Packet_Data;
    uint8 Packet_Type;
    Fixed_Beacon Fixed_Beacon_Packet;
    Near_Car_Beacon Near_Car_Beacon_Packet;
    uint8 Acceleration_Type;
    uint8 Sequence_No;
    uint8 FCS;
};

 
 extern uint8 Send_Lora_Packet_Flag;
 extern int Lora_RxBuffer_Crnt_Pos,Lora_RxBuffer_End_Pos; // must be volatile or the compiler may over-optimise.
 extern int receivedDataCount;
 extern char LORA_UART_RX_Buffer[LORA_UART_RX_Size];
 extern int LORA_UART_RX_Crnt_Pos;
 extern uint8 Lora_Command_Rcvd[100];
 extern uint8 Lora_Cmd_Length;
 extern uint8 AT_Response_Receive_Status; 
 extern uint8 Vehicle_Identification_Number[17];                     //Unique Vehicle_Identification_Number, Read using OBD
 extern uint8 Motion_Packet_Sent_Count;
 extern uint8 CheckIN_Packet_Sent_Count;
 extern uint8 Lora_Packet_To_Send[100];
 
 extern uint8 OBD_Protocol_Version;
 extern Heart_Beat_PacketType Heart_Beat_Lora_Packet;    //Allocate Memory for HeartBeat Lora Packets
 extern CheckIN_PacketType CheckIN_Lora_Packet; //Allocate Memory for CheckIN Lora Packets
 extern Motion_PacketType Motion_Lora_Packet;    //Allocate Memory for Movement Lora Packets
 extern Vehicle_Status_PacketType Vehicle_Status_Lora_Packet;    //Allocate Memory for Movement Lora Packets
 extern Near_Car_Beacon Near_Car_Packet;
 extern Fixed_Beacon Fixed_Beacon_Packet;
 extern CheckOUT_PacketType CheckOUT_Packet;
 extern Misc_Packets Misc_Packet_Data;
    
void Send_Lora_Packet_To_Gateway(uint8* Command_To_Send,uint8 Length);
extern void Flip_Lora_Packet_Sending(); 
extern void Lora_Periodic_Packet_Sending_thread(void const *arg);
void Initialize_lora_Packets();
static void Process_Received_Response(uint8 Response_Length);
void Read_Lora_END_Node_ID(uint8* Buffer,uint8 Start_Position,uint8 Response_Length);
//extern void Lora_Rcvd_Cmd_Processing_thread(void const *args);
void Get_Acceleration_Type(void);
void Send_Motion_Packet(void);
void Send_CheckIN_Packet(void);
void Send_CheckOUT_Packet(void);
void Send_HeartBeat_Packet(void);
void Send_Vehicle_Status_Packet(void);
extern uint8 Calculate_Lora_Frame_FCS(uint8* Packet_Data,uint8 Packet_Length);
extern void Set_Up_Lora_Network_Configuration(void);
extern void Get_Lora_Response(void);
