#include "mbed.h"
#include "rtos.h"
#include "OBD.h"
#include "Lora.h"
#include "Accelerometer.h"
#include "Beacon.h"
#include "main.h"

//Datatype typecasting
typedef unsigned char uint8;
typedef unsigned int uint16;

uint8 OBD_Plug_In_Status = FALSE;

//peripheral connection
DigitalOut led1(PB_11);
DigitalOut led2(LED2);
DigitalIn Switch2(PB_13);

//Configure Serial port
RawSerial LORA_UART(PA_0, PA_1);//USART4_TX->PA_0,USART4_RX->PA_1      :       Used for Lora module command sending and reception from gateway
//RawSerial pc1(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10   :       Used for debugging purpose only
//RawSerial DEBUG_UART(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10   :       Used for debugging purpose only
RawSerial Beacon_UART(PC_4, PC_5);//USART3_TX->PC4,USART3_RX->PC_5     :       Used for sending command to beacon module
RawSerial BLE_RECEIVER_UART(PA_9, PA_10);//USART1_TX->PA_0,USART1_RX->PA_1      :       Used for Lora module command sending and reception from gateway
Serial pc1(USBTX, USBRX);
RawSerial DEBUG_UART(USBTX, USBRX);//USART1_TX->PA_9,USART1_RX->PA_10   :       Used for debugging purpose only

//InterruptIn OBD_PLUGIN_INTERRUPT_PIN(PC_13);
InterruptIn CheckIn_Interrupt(PB_7);//(PC_13);
InterruptIn Motion_Start_To_Stop(PB_5);//(PC_13);
InterruptIn Motion_Stop_To_Start(PB_14);//(PC_13);
InterruptIn Motion_Sudden_Jerk(PC_13);//(PC_13);


uint8 Ticker_Count = 0;    //Variable to count for timer overflows

uint8 OBD_Plugin_Detected = FALSE;

//Create Object for structure of Lora Packet to be sent

static uint16 Calculate_Wheels_RPM(uint8* Buffer);
void flip_Packet_Sending_Flag();
void Lora_Periodic_Packet_Sending_thread(void const *args);

void Lora_Rcvd_Cmd_Processing_thread(void);// const *args);
void Enable_CheckIN_Packet_Sending();

const char GET_RSSI[]= {0x41,0x54,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x0D,0x0A};
const char SET_BEACON_VENDOR_ID[]= {0x41,0x54,0xF1,0x01,0x02,0x00,0x00,0x00,0x00,0xF2,0x0D,0x0A};
const char SET_BEACON_MESSAGE_TYPE[]= {0x41,0x54,0xF2,0x01,0x00,0x00,0x00,0x00,0x00,0xF3,0x0D,0x0A};
/*************************Accelerometer related definitions***********************************/
//Accelerometer related definitions

#define DOUBLE_TAP_INTERRUPT        0x20
#define ACTIVITY_INTERRUPT          0x10
#define INACTIVITY_INTERRUPT        0x08

#define TAP_THRESHOLD               75
#define ACTIVITY_THRESHOLD          64      // THRES_ACT register value 62.5mg/LSB , therfore value 32 indicates 2g activity
#define INACTIVITY_THRESHOLD        50

#define DUR_TIME                    0x15    // DUR Register value providing maximum time to be held to generate an interrupt
#define LATENT_TIME                 0x15    // The interrupt latency
#define WINDOW_TIME                 0x45    // The time of the interrupt window in which the next tap will be detected 
#define INACTIVITY_VALIDATION_TIME  5       // The time until which the acceleration must be held below the inactivity threshold to generate an inactvity interrupt
// Here the value 5 indicates literally 5 secs
#define X_AXIS_OFFSET               0x7F
#define Y_AXIS_OFFSET               0x7F
#define Z_AXIS_OFFSET               0x05

Serial pc(USBTX, USBRX);
I2C i2c(PB_9, PB_8);

InterruptIn activity(PB_0);
InterruptIn inactivity(PA_4); // As for now only this is used
DigitalOut led(LED1);

const int slave_address_acc = 0xA6;
char axis_data[6] = {0,0,0,0,0,0};

char interrupt_source[2];
char axis_data_start_address[2] = {0x32, 0};
char intr_source_address[2] = {0x30, 0};
char all_interrupt_clear_command[2] = {0x2E, 0x00};
char all_interrupt_enable_command[2] = {0x2E, 0x38};
char activity_interrupt_disable_command[2] = {0x2E, 0x08};
char inactivity_interrupt_disable_command[2] = {0x2E, 0x30};
char accelerometer_status_registered = 0;
unsigned int interrupt_source_duplicate;

char threshold_offset_command[5];
char act_inact_time_config_command[8];
char interrupt_enable_command[3];
char tap_axis_enable_command[2];
char baud_rate_command[2];
char data_format_command[2];
char measure_bit_on_command[2];


unsigned char vehicle_speed = 25;                                       // Kmph
unsigned char current_speed, previous_speed, speed_threshold = 10;      // Kmph

unsigned char x_axis, y_axis, z_axis;

unsigned char Motion_Detect_Status = FALSE;
uint8 OBD_PlugInOut_IOC_Status = FALSE;
unsigned char Motion_Type_Detected = MOTION_TYPE_UNKNOWN;    //By default set motion type as unknown
void Accelerometer_Process_thread();//void const *args) ;

#define BLE_RECEIVER_UART_RX_Size 100
uint8 BLE_RxBuffer_End_Pos = 0;
char BLE_Receiver_UART_RX_Buffer[BLE_RECEIVER_UART_RX_Size];

//This function is Interrupt routine for detecting motion(acceleartion), i.e. either starts from rest/vehicle stops afeter running or if sudden jurk is detected
void interrupt_activity_inactivity()
{
    i2c.write(slave_address_acc, all_interrupt_clear_command, 2);
    Motion_Detect_Status = TRUE;
}


/************************************************************************/
uint8 Command_Sent[100];
uint8 Command_Length_Sent;
uint8 Checkin_Detect_Status = FALSE;
void Extract_Received_Lora_Response(void);
void Send_Command_To_BLE_Receiver(const char* Command);

char previous_state = 0;
char current_state = 0;

uint8 OBD_PlugIN_State=0;
uint8 OBD_PlugIN_State1=0;
uint8 OBD_PlugIN_State2=0;
uint8 OBD_PlugIN_Temp_State=1;

uint8 Start_To_Stop_Status = FALSE;
uint8 Stop_To_Start_Status = FALSE;
uint8 Jerk_Status = FALSE;

void Start_To_Stop_Interrupt()
{
    Start_To_Stop_Status = TRUE;
    Motion_Detect_Status = TRUE;
}

void Stop_To_Start_Interrupt()
{
    Stop_To_Start_Status = TRUE;
    Motion_Detect_Status = TRUE;
}

void Sudden_Jerk_Interrupt()
{
    Jerk_Status = TRUE;
    Motion_Detect_Status = TRUE;
}
void OBD_Plug_IN_Interrupt()
{
    if(OBD_PlugIN_State1!=OBD_PlugIN_Temp_State) {
        OBD_PlugIN_State1=1;
        OBD_PlugIN_State=!OBD_PlugIN_State;
        OBD_PlugIN_Temp_State=OBD_PlugIN_State;
        OBD_PlugInOut_IOC_Status = TRUE;
    }
}

void OBD_Plug_OUT_Interrupt()
{
    
    if(OBD_PlugIN_State2!=OBD_PlugIN_Temp_State) {
        OBD_PlugIN_State2=0;
        OBD_PlugIN_State=!OBD_PlugIN_State;
        OBD_PlugIN_Temp_State=OBD_PlugIN_State;
        OBD_PlugInOut_IOC_Status = TRUE;
    }
}

//This function is Interrupt routine for detecting OBD Plugin and Out
void Handle_CheckIn_Interrupt()
{
    OBD_PlugInOut_IOC_Status = TRUE;
    pc.printf("\nMovement_Detected\n");
}

//Declare Ticker for sending lora packet
Ticker Lora_Packet_Sending_Ticker;
void flip_Packet_Sending_Flag(void)
{
    led1=!led1;
    //flip function
    if(Ticker_Count < 5) {
        Ticker_Count++;
    } else {
        Ticker_Count = 0;
        Send_Lora_Packet_Flag = TRUE;
    }
}

// called every time a byte is received from lora module.
void Lora_onDataRx()
{
    while (LORA_UART.readable()) {
        // while there is data waiting
        LORA_UART_RX_Buffer[Lora_RxBuffer_End_Pos++] = LORA_UART.getc(); // put it in the buffer
        //pc1.putc(LORA_UART_RX_Buffer[Lora_RxBuffer_End_Pos-1]);
        if(Lora_RxBuffer_End_Pos >= LORA_UART_RX_Size) {
            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
            // For now just throw everything away.
            Lora_RxBuffer_End_Pos  = 0;
        }
    }
}

// called every time a byte is received from Beacon Module.
void Beacon_onDataRx()
{
    while (Beacon_UART.readable()) {
        // while there is data waiting
        Beacon_RX_Buffer[Beacon_RxBuffer_End_Pos++] = Beacon_UART.getc(); // put it in the buffer
        pc1.printf("%2x",Beacon_RX_Buffer[Beacon_RxBuffer_End_Pos-1]);
        if(Beacon_RxBuffer_End_Pos >= 100) {
            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
            // For now just throw everything away.
            Beacon_RxBuffer_End_Pos  = 0;
        }
    }
}

void BLE_Receiver_onDataRx(void)
{
    while (BLE_RECEIVER_UART.readable()) {
        // while there is data waiting
        //BLE_Receiver_UART_RX_Buffer[BLE_RxBuffer_End_Pos++] = BLE_RECEIVER_UART.getc(); // put it in the buffer
        //pc1.putc(BLE_Receiver_UART_RX_Buffer[BLE_RxBuffer_End_Pos-1]);
        if(BLE_RxBuffer_End_Pos >= BLE_RECEIVER_UART_RX_Size) {
            // BUFFER OVERFLOW. What goes here depends on how you want to cope with that situation.
            // For now just throw everything away.
            BLE_RxBuffer_End_Pos  = 0;
        }
    }
}

int main()
{
    pc1.baud(115200);
    BLE_RECEIVER_UART.baud(115200);
    pc1.printf("%s","Debugging started\n");
    //BLE_RECEIVER_UART.attach(&BLE_Receiver_onDataRx, Serial::RxIrq);
    LORA_UART.attach(&Lora_onDataRx, Serial::RxIrq);
   CheckIn_Interrupt.fall(&OBD_Plug_IN_Interrupt);
    CheckIn_Interrupt.rise(&OBD_Plug_OUT_Interrupt);
    if(Switch2)
    {
    }
    Motion_Start_To_Stop.fall(&Start_To_Stop_Interrupt);
    Motion_Stop_To_Start.fall(&Stop_To_Start_Interrupt);
    Motion_Sudden_Jerk.fall(&Sudden_Jerk_Interrupt);
    //Create a thread to read vehicle data
    //Thread OBD_thread(OBD_Rcvd_Cmd_Processing_thread);

    Lora_Packet_Sending_Ticker.attach(&flip_Packet_Sending_Flag, 3.0); // call flip_Packet_Sending_Flag function every 5 seconds

    // OBD_PLUGIN_INTERRUPT_PIN.rise(&Enable_CheckIN_Packet_Sending);  // call toggle function on the rising edge
    //led2_thread is executing concurrently with main at this point
    //inactivity.rise(interrupt_activity_inactivity); // Attach the address of interrupt_activity_inactivity function to rising edge
    Initialize_Beacon_Module();
   // Send_Command_To_BLE_Receiver(SET_BEACON_VENDOR_ID);
   // Send_Command_To_BLE_Receiver(SET_BEACON_MESSAGE_TYPE);
    pc1.printf("\n%s","Transmitter MAC ID received\n");
    Lora_Periodic_Packet_Sending(); //Infinite loop for sending and receiving lora response, no return from here
}

void Send_Command_To_BLE_Receiver(const char* Command)
{
    uint8 i;
    for(i=0;i<12;i++)
        BLE_RECEIVER_UART.putc(Command[i]);
}
//Function to be called when Interrupt is genearted for motion sensing, checkin
void Initialize_Packets_Sent_Count(void)
{
    Motion_Packet_Sent_Count = 0x00;
    CheckIN_Packet_Sent_Count = 0x00;
}

uint8 Status_Packet_Wait_Count = 0;
void Lora_Periodic_Packet_Sending()
{
    pc1.printf("\nPeriodic packet sending intiialized\n");
    Set_Up_Lora_Network_Configuration();
    Initialize_lora_Packets();
    Send_Lora_Packet_Flag = TRUE;
    while (true) {
        if(Packet_Type_To_Send == HEARTBEAT_TYPE_PACKET) {  //check if packet to be sent is Heartbeat packet
            if(Send_Lora_Packet_Flag) {     //Check if packet sending is enabled, Packet should be sent only when enabled after timeout period
                pc1.printf("\nStatus_Packet_Wait_Count %d\n",Status_Packet_Wait_Count);
                Status_Packet_Wait_Count++;
                if(Status_Packet_Wait_Count < 4) {
                   // Send_Command_To_BLE_Receiver(GET_RSSI);
                    //Send_RSSI_Request_Command(GET_RSSI);
                    pc1.printf("\nSending heartbeat packet\n");                               //call function to send periodic motion packet
                    Send_HeartBeat_Packet();                            //call function to send heartbeat packet
                    pc.printf("\nSent HeartBeat Packet\n");
                    /*AT_Response_Receive_Status = FAILURE;
                    while(AT_Response_Receive_Status)
                        Get_Lora_Response();
                    */Send_Lora_Packet_Flag = FALSE;
                    pc1.printf("\nHeartbeat Packet Response Received\n");
                } else {
                    //Send_RSSI_Request_Command(GET_RSSI);
                    Status_Packet_Wait_Count = 0;
                    pc1.printf("\nSending Vehicle status packets\n");                               //call function to send periodic motion packet
                    Send_Vehicle_Status_Packet();                            //call function to send heartbeat packet
                    pc1.printf("\nSent Vehicle Status Packet\n");
                    //AT_Response_Receive_Status = FAILURE;
                   // while(AT_Response_Receive_Status)
                    //    Get_Lora_Response();
                    Send_Lora_Packet_Flag = FALSE;
                    Packet_Type_To_Send = HEARTBEAT_TYPE_PACKET;
                    //pc1.printf("\nStatus Packet Response Received\n");
                }
            }
        } else if(Packet_Type_To_Send == MOTION_TYPE_PACKET) {  //check if packet to be sent is motion packet
            if(Send_Lora_Packet_Flag) {                         //Check if packet sending isd enabled, Packet should be sent only when enabled after timeout period
                //Send_RSSI_Request_Command(GET_RSSI);
                pc1.printf("\nSending Motion Packet\n");                               //call function to send periodic motion packet
                Send_Motion_Packet();
                pc1.printf("\nSent Motion Packet\n");                               //call function to send periodic motion packet
                AT_Response_Receive_Status = FAILURE;
                while(AT_Response_Receive_Status)
                    Get_Lora_Response();
                pc1.printf("\nMotion Packet Response Received\n");
                Send_Lora_Packet_Flag = FALSE;
                if(Motion_Packet_Sent_Count >= 5) {             //Stop Sending Motion Packets if after sending for 2 minute
                    pc1.printf("\nPacket Type Sending Changed to HeartBeat\n");
                    Motion_Packet_Sent_Count = 0;
                    Packet_Type_To_Send = HEARTBEAT_TYPE_PACKET;    //Set Packet type to send as heartbeat packet
                    Lora_Packet_Sending_Ticker.detach();          //destroy ticker
                    Lora_Packet_Sending_Ticker.attach(&flip_Packet_Sending_Flag, 10.0); //create new ticker
                }
            }
        } else if(Packet_Type_To_Send == CHECKIN_TYPE_PACKET) { //check if packet to be sent is Checkin packet
            if(Send_Lora_Packet_Flag) {     //Check if packet sending isd enabled, Packet should be sent only when enabled after timeout period
                Send_Lora_Packet_Flag = FALSE;
                //pc1.printf("\nSent Beacon ID request\n");
               // Send_RSSI_Request_Command(GET_RSSI);
                if(OBD_PlugIN_State)
                {
                    pc1.printf("\nSening Checkin Packet\n");
                    Send_CheckIN_Packet();                              //call function to send periodic checkIn packet
                    pc1.printf("\nSent Checkin Packet\n");
                    //Process_Beacon_Command_Received(SET_VIRTUAL_PACKET_UUID);
                    //wait(.2);
                    //Process_Beacon_Command_Received(SOFT_REBOOT1);
                }
                else
                {
                    pc1.printf("\nSending Checkout Packet\n");
                    Send_CheckOUT_Packet();
                    pc1.printf("\nSent CheckOut Packet\n");
                    //Process_Beacon_Command_Received(SET_VIRTUAL_PACKET_UUID2);
                    //wait(.2);
                    //Process_Beacon_Command_Received(SOFT_REBOOT1);
                }
               /* AT_Response_Receive_Status = FAILURE;
                while(AT_Response_Receive_Status)
                    Get_Lora_Response();*/
                if(CheckIN_Packet_Sent_Count >= 5) { //Stop Sending Motion Packets if after sending for 2 minute
                    pc1.printf("\nPacket Type Sending Changed to HeartBeat\n");
                CheckIN_Packet_Sent_Count = 0;
                Packet_Type_To_Send = HEARTBEAT_TYPE_PACKET;    //Set Packet type to send as heartbeat packet
                Initialize_Packets_Sent_Count();
                }
            }
        }
        if(OBD_PlugInOut_IOC_Status) {  //Check if Accelerometer Interrupt is generated
            //Enable_CheckIN_Packet_Sending();
            //Get_Acceleration_Type();
           // Process_Beacon_Command_Received(SET_VIRTUAL_PACKET_UUID);
           // Process_Beacon_Command_Received(SOFT_REBOOT1);
            OBD_PlugInOut_IOC_Status = FALSE;
            Packet_Type_To_Send = CHECKIN_TYPE_PACKET;
            Send_Lora_Packet_Flag = TRUE;
            CheckIN_Packet_Sent_Count = 0;
            CheckIN_Lora_Packet.Sequence_No = 0x01;  //Reset counter
            CheckOUT_Packet.Sequence_No = 0x01;  //Reset counter
            wait(1); //wait for 1sec to avoid detecting plugin debounce
        }
        if(Motion_Detect_Status) {  //Check if Accelerometer Interrupt is generated
            Motion_Lora_Packet.Sequence_No = 0x01;  //Reset counter
            Motion_Packet_Sent_Count = 0x00; //reset counetr
            Get_Acceleration_Type();
            Motion_Detect_Status = FALSE;
            Start_To_Stop_Status = FALSE;
            Jerk_Status = FALSE;
            Stop_To_Start_Status = FALSE;
            wait(1); //wait for 1sec to avoid detecting switch debounce
        }
    }
}

void Get_Acceleration_Type(void)
{
    Packet_Type_To_Send = MOTION_TYPE_PACKET;       //whenever acceleration is detected change the packet type to be sent to motion type
    Lora_Packet_Sending_Ticker.detach();            //destroy ticker
    Lora_Packet_Sending_Ticker.attach(&flip_Packet_Sending_Flag, 5.0); //create new ticker, time inetrval value to be changed
    Send_Lora_Packet_Flag = 1;                      //set flag to send motion packet as soon as motion is detecetd
    if(Start_To_Stop_Status)
        Motion_Lora_Packet.Acceleration_Type = MOTION_TYPE_START_TO_STOP;             //Read Type of motion deteceted
    if(Stop_To_Start_Status)
        Motion_Lora_Packet.Acceleration_Type = MOTION_TYPE_STOP_TO_START;             //Read Type of motion deteceted
    if(Jerk_Status)
        Motion_Lora_Packet.Acceleration_Type = MOTION_TYPE_TAP;             //Read Type of motion deteceted
    //write code to read acceleration value for every 10sec after any of the acceleration is found
}

/*
//This function is used to enable checkin packet sending once OBD device is plugged in
void Enable_CheckIN_Packet_Sending()
{
   // Enable_CheckIN_Packet_Sending = TRUE;  //set status to true
    if(Command_Received[0] == 0xFE) //check start of frame of packet received. every packet must start with 0xFE
    {
        if(Calculate_Lora_Frame_FCS((Command_Received + 1),(Command_Length + 1)) == (Command_Received[Command_Length + 2]))  //Check for packet inegrity by checking FCS
        {
            if((Command_Received[0] == SET_BEACON_CMD0) && (Command_Received[1] == SET_BEACON_CMD1))    //Check if command is received for setting beacon parameters
            {
                Process_Beacon_Command_Received((Command_Received + 2));
            }
        }
    }
} */

void Send_RSSI_Request_Command(const char* Command_To_Send)
{
    //BLE_RECEIVER_UART.printf(Command_To_Send);
    Get_Fixed_Beacon_RSSI();
}

void Get_Fixed_Beacon_RSSI(void)
{
    uint8 i;
    uint8 Temp_Pos=0;
    /*Fixed_Beacon_Packet.Parking1_Beacon_ID[0] = 0xA0;
    Fixed_Beacon_Packet.Parking1_Beacon_ID[1] = 0xAC;
    Fixed_Beacon_Packet.Parking1_Beacon_ID[2] = 0x51;
    Fixed_Beacon_Packet.Parking1_Beacon_ID[3] = 0x3F;
    Fixed_Beacon_Packet.Parking1_Beacon_ID[4] = 0x91;
    Fixed_Beacon_Packet.Parking1_Beacon_ID[5] = 0xE0;
    Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength = 0xC3;
    Fixed_Beacon_Packet.Parking2_Beacon_ID[0] = 0xDC;
    Fixed_Beacon_Packet.Parking2_Beacon_ID[1] = 0xA3;
    Fixed_Beacon_Packet.Parking2_Beacon_ID[2] = 0x6D;
    Fixed_Beacon_Packet.Parking2_Beacon_ID[3] = 0x30;
    Fixed_Beacon_Packet.Parking2_Beacon_ID[4] = 0x38;
    Fixed_Beacon_Packet.Parking2_Beacon_ID[5] = 0xDF;
    Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength = 0xB4;
    Fixed_Beacon_Packet.Parking3_Beacon_ID[0] = 0x6C;
    Fixed_Beacon_Packet.Parking3_Beacon_ID[1] = 0x29;
    Fixed_Beacon_Packet.Parking3_Beacon_ID[2] = 0xB6;
    Fixed_Beacon_Packet.Parking3_Beacon_ID[3] = 0x27;
    Fixed_Beacon_Packet.Parking3_Beacon_ID[4] = 0x3A;
    Fixed_Beacon_Packet.Parking3_Beacon_ID[5] = 0xC9;
    Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength = 0xB0;
    */
    pc1.printf("\nReading MACID from Receiver\n");
    while(true)
    {
        wait_ms(2);
        if(Temp_Pos <= BLE_RxBuffer_End_Pos)
        {
            if(BLE_Receiver_UART_RX_Buffer[Temp_Pos] == 0x0D)
            {
                if(BLE_Receiver_UART_RX_Buffer[Temp_Pos+1] == 0x0A)
                {
                    Temp_Pos = 2;
                    //pc1.printf("\nFixed Beacon1 MAC ID\n");
                    for(i=0; i<6; i++)
                    {
                       Fixed_Beacon_Packet.Parking1_Beacon_ID[i] = BLE_Receiver_UART_RX_Buffer[Temp_Pos++];
                       pc1.putc(Fixed_Beacon_Packet.Parking1_Beacon_ID[i]);
                    }
                    Temp_Pos+=2;
                    Fixed_Beacon_Packet.Parking1_Beacon_Signal_Strength = BLE_Receiver_UART_RX_Buffer[Temp_Pos++];
                    //pc1.printf("\nFixed Beacon2 MAC ID\n");
                    for(i=0; i<6; i++)
                    {
                        Fixed_Beacon_Packet.Parking2_Beacon_ID[i] = BLE_Receiver_UART_RX_Buffer[Temp_Pos++];
                        pc1.putc(Fixed_Beacon_Packet.Parking2_Beacon_ID[i]);
                    }
                    Temp_Pos+=2;
                    Fixed_Beacon_Packet.Parking2_Beacon_Signal_Strength = BLE_Receiver_UART_RX_Buffer[Temp_Pos++];
                    //pc1.printf("\nFixed Beacon3 MAC ID\n");
                    for(i=0; i<6; i++)
                    {
                       Fixed_Beacon_Packet.Parking3_Beacon_ID[i] = BLE_Receiver_UART_RX_Buffer[Temp_Pos++];
                       pc1.putc(Fixed_Beacon_Packet.Parking3_Beacon_ID[i]);
                    }
                    Temp_Pos+=2;
                    Fixed_Beacon_Packet.Parking3_Beacon_Signal_Strength = BLE_Receiver_UART_RX_Buffer[Temp_Pos++];
                    BLE_RxBuffer_End_Pos = 0x00;    //Start Next adat at 0th location
                    break;
                }
                Temp_Pos++;
            }
            else
                Temp_Pos++;
        }
        else
            Temp_Pos = 0x00;
    }
    pc1.printf("\nReading MACID finished\n");
}
