#include "mbed.h"
#include "Common_Defs.h"

//Macro Definitions
#define SET_BEACON_UUID_CMD0            0x01
#define SET_BEACON_UUID_CMD1            0x01
#define SET_SET_MAJOR_CMD0              0x01
#define SET_SET_MAJOR_CMD1              0x02
#define SET_SET_MINOR_CMD0              0x01
#define SET_SET_MINOR_CMD1              0x03
#define SET_SET_MEASURED_POWER_CMD0     0x01
#define SET_SET_MEASURED_POWER_CMD1     0x04
#define SET_TRANSMISSION_POWER_CMD0     0x01
#define SET_TRANSMISSION_POWER_CMD1     0x05
#define SET_PAIRING_PASSWORD_CMD0       0x01
#define SET_PAIRING_PASSWORD_CMD1       0x06
#define SET_BROADCAST_INTERVAL_CMD0     0x01
#define SET_BROADCAST_INTERVAL_CMD1     0x07
#define SET_IBEACON_NAME_CMD0           0x01
#define SET_IBEACON_NAME_CMD1           0x08
#define SET_START_BEACON_CMD0           0x01    //Open Beacon
#define SET_START_BEACON_CMD1           0x09
#define SET_STOP_BEACON_CMD0            0x01    //Close Beacon
#define SET_STOP_BEACON_CMD1            0x0A
#define SET_SOFT_REBOOT_CMD0            0x01
#define SET_SOFT_REBOOT_CMD1            0x0B

extern unsigned char SOFT_REBOOT1[15];
extern unsigned char SET_VIRTUAL_PACKET_UUID[23];
extern unsigned char SET_VIRTUAL_PACKET_UUID2[23];

extern unsigned char SET_UUID[21];
extern unsigned char SET_MAJOR[7];           
extern unsigned char SET_MINOR[7];
extern unsigned char SET_MEASURED_POWER[6];
extern unsigned char SET_TRANSMISSION_POWER[6];
extern unsigned char SET_PAIRING_PASSWORD[13];
extern unsigned char SET_BROADCAST_INTERVAL[6];
extern unsigned char SET_IBEACON_NAME[17];
extern unsigned char SOFT_REBOOT[13];
extern unsigned char SET_OPEN_BEACON[7];
extern unsigned char SET_CLOSE_BEACON[8];
extern uint8 BLE_Adv_Module_Beacon_ID[6];

 extern uint8 Beacon_RxBuffer_Crnt_Pos,Beacon_RxBuffer_End_Pos; // must be volatile or the compiler may over-optimise.
 extern uint8 Beacon_RX_Buffer[100];
 
extern void Process_Beacon_Command_Received(unsigned char* Command_Received);
extern void Change_Beacon_Parameter(unsigned char* Beacon_Parameter_To_Set);
extern void Initialize_Beacon_Module(void);