#include "Beacon.h"
#include "Lora.h"

 RawSerial DEBUG_UART2(PA_14, PA_15);//USART1_TX->PA_9,USART1_RX->PA_10
 RawSerial Beacon_Module_UART(PC_4, PC_5);//USART3_TX->PC4,USART3_RX->PC_5
 
 
 uint8 Beacon_RxBuffer_Crnt_Pos,Beacon_RxBuffer_End_Pos; // must be volatile or the compiler may over-optimise.
 uint8 Beacon_RX_Buffer[100];
 char Beacon_RxIndex=0;
 uint8 BLE_Adv_Module_Beacon_ID[6];
   
/*Instructions for operation(MS49SF1U)
1. UART command list(Commands for modifying configuration)
|-------------------|-----------------------------|---------------|---------------------------------------------------|
|     Item          |       Command format        |  Length(data) |      Returned value after successful receiving    |
|-------------------|-----------------------------|---------------|---------------------------------------------------|
UUID                    0x4154+0xFFF1+data+0x0d     16character                     0xFFF1+received data
Major                   0x4154+0xFFF2+data+0x0d     2character                      0xFFF2+received data
Minor                   0x4154+0xFFF3+data+0x0d     2character                      0xFFF3+received data
Measured power          0x4154+0xFFF4+data+0x0d     1character                      0xFFF4+received data
Transmission power      0x4154+0xFFF5+data+0x0d     1character                      0xFFF5+received data
Pairing Password        0x4154+0xFFF6+data+0x0d     8character                      0xFFF6+received data
Broadcasting Interval   0x4154+0xFFF7+data+0x0d     1character                      0xFFF7+received data
Beacon_Serial_ID        0x4154+0xFFF8+data+0x0d     4character                      0xFFF8+received data
iBeacon_name            0x4154+0xFFF9+data+0x0d     12character                     0xFFF9+received data
Authentication          0x4154+0xFFFA+data+0x0d     12character                     0xFFFA+received data
Connection Mode         0x4154+0xFFFE+data+0x0d     1character                      0xFFFE+received data
Soft Reboot             0x4154+0xFFFF+data+0x0d     8character                      0xFFFF+received data+0K or ERROR
open beacon             0x4154+0x6F70656E+0x0d                                      return Beacon is open\n
close beacon            0x4154+0x636C6F7365+0x0d                                    return Beacon is closed\n
app enable              0x4154+0x656E61626C65+0x0d                                  return app enabled
app unable              0x4154+0x756E61626C65+0x0d
Read MAC ID             0x5244+0x6d6163+0x0d
-------------------------------------------------------------------------------------------------------------------
*/

unsigned char SET_UUID[21] = {0x41,0x54,0xFF,0xF1,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D};
unsigned char SET_VIRTUAL_PACKET_UUID[23] = {0x01,0x01,0x41,0x54,0x01,0x01,0x02,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x03,0x0B,0x0C,0x05,0x0E,0x0F,0x0D};
unsigned char SET_VIRTUAL_PACKET_UUID1[23] = {0x41,0x54,0xFF,0xF1,0x02,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x02,0x0B,0x0C,0x05,0x0E,0x0F,0x0D};
unsigned char SET_VIRTUAL_PACKET_UUID2[23] = {0x12,0x21,0x41,0x54,0xFF,0xF1,0x0F,0x0E,0x0D,0x0C,0x0B,0x0A,0x09,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0D};
unsigned char SET_VIRTUAL_PACKET_UUID3[23] = {0x41,0x54,0xFF,0xF1,0x0F,0x0E,0x0D,0x0C,0x0B,0x04,0x05,0x08,0x07,0x06,0x05,0x04,0x03,0x02,0x01,0x00,0x0D};
unsigned char SET_MAJOR[7] = {0x41,0x54,0xFF,0xF2,0x00,0x00,0x0D};           
unsigned char SET_MINOR[7] = {0x41,0x54,0xFF,0xF3,0x00,0x00,0x0D};
unsigned char SET_MEASURED_POWER[6] = {0x41,0x54,0xFF,0xF4,0x00,0x0D};
unsigned char SET_TRANSMISSION_POWER[6] = {0x41,0x54,0xFF,0xF5,0x00,0x0D};
unsigned char SET_PAIRING_PASSWORD[13] = {0x41,0x54,0xFF,0xF6,0x4F,0x42,0x44,0x21,0x30,0x30,0x30,0x31,0x0D};//Set Password here, Now set as OBD!1234
unsigned char SET_BROADCAST_INTERVAL[6] = {0x41,0x54,0xFF,0xF7,0x00,0x0D};
unsigned char SET_IBEACON_NAME[17] = {0x41,0x54,0xFF,0xF9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D};
unsigned char SOFT_REBOOT[13] = {0x41,0x54,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0D};
unsigned char SET_OPEN_BEACON[7] = {0x41,0x54,0x6F,0x70,0x65,0x6E,0x0D};
unsigned char SET_CLOSE_BEACON[8] = {0x41,0x54,0x63,0x6C,0x6F,0x73,0x65,0x0D};
unsigned char READ_BEACON_MAC_ID[6] = {0x52,0x44,0x6D,0x61,0x63,0x0D};

unsigned char SOFT_REBOOT1[15] = {0x01,0x0B,0x41,0x54,0xFF,0xFF,0x6D,0x69,0x6E,0x65,0x77,0x31,0x32,0x33,0x0D};
unsigned char SOFT_REBOOT2[15] = {0x41,0x54,0xFF,0xFF,0x6D,0x69,0x6E,0x65,0x77,0x31,0x32,0x33,0x0D};

void Process_Beacon_Command_Received(unsigned char* Command_Received);
void Change_Beacon_Parameter(unsigned char* Beacon_Parameter_To_Set);
void Get_Beacon_Response(void);
void Read_Beacon_Module_MAC_ID(void);
void Initialize_Beacon_Module(void);

void Process_Beacon_Command_Received(unsigned char* Command_Received)
{
    static unsigned char Temp_Pos,Start_Position,End_Position,Data_Length;
    Start_Position = 0x02;
    Temp_Pos = 0x02;
    if((Command_Received[0] == SET_BEACON_UUID_CMD0) && (Command_Received[1] == SET_BEACON_UUID_CMD1))   //Check if command is receievd for setting UUID
    {
        //DEBUG_UART2.printf("Setting UUID");
        Data_Length = 16;
        End_Position = (Start_Position + Data_Length);
        for(;Start_Position < End_Position;Start_Position++)
        {
            SET_UUID[Start_Position] = Command_Received[Temp_Pos++];
            //DEBUG_UART2.putc(SET_UUID[Start_Position]);
            //DEBUG_UART2.printf("%s",SET_UUID);
            
            
        }
        DEBUG_UART2.printf("UUID Set");
        Change_Beacon_Parameter(SET_VIRTUAL_PACKET_UUID1);
    }
    else if((Command_Received[0] == 0x12) && (Command_Received[1] == 0x21))   //Check if command is receievd for setting UUID
    {
        DEBUG_UART2.printf("Setting UUID2");
        Data_Length = 16;
        End_Position = (Start_Position + Data_Length);
        for(;Start_Position < End_Position;Start_Position++)
        {
            SET_UUID[Start_Position] = Command_Received[Temp_Pos++];
            //DEBUG_UART2.putc(SET_UUID[Start_Position]);
            //DEBUG_UART2.printf("%s",SET_UUID);
            
            
        }
        DEBUG_UART2.printf("UUID2 Set");
        Change_Beacon_Parameter(SET_VIRTUAL_PACKET_UUID3);
    }
    else if((Command_Received[0] == SET_SET_MAJOR_CMD0) && (Command_Received[1] == SET_SET_MAJOR_CMD1))  //Check if command is received for Setting Major
    {
        SET_MAJOR[Start_Position++] = Command_Received[Temp_Pos++]; //MSB
        SET_MAJOR[Start_Position] = Command_Received[Temp_Pos];     //LSB
        DEBUG_UART2.printf("%s",SET_MAJOR);
        Change_Beacon_Parameter(SET_MAJOR);
    }
    else if((Command_Received[0] == SET_SET_MINOR_CMD0) && (Command_Received[1] == SET_SET_MINOR_CMD1))  //Check if command is received for Setting Minor
    {
        SET_MINOR[Start_Position++] = Command_Received[Temp_Pos++]; //MSB
        SET_MINOR[Start_Position] = Command_Received[Temp_Pos];     //LSB
        DEBUG_UART2.printf("%s",SET_MINOR);                          
        Change_Beacon_Parameter(SET_MINOR);                         
    }
    else if((Command_Received[0] == SET_SET_MEASURED_POWER_CMD0) && (Command_Received[1] == SET_SET_MEASURED_POWER_CMD1))  //Check if command is received for Setting Measured power
    {
        SET_MEASURED_POWER[Start_Position] = Command_Received[Temp_Pos];
        DEBUG_UART2.printf("%s",SET_MEASURED_POWER);
        Change_Beacon_Parameter(SET_MEASURED_POWER);
    }
    else if((Command_Received[0] == SET_TRANSMISSION_POWER_CMD0) && (Command_Received[1] == SET_TRANSMISSION_POWER_CMD1))  //Check if command is received for settting Transmission power
    {
        SET_TRANSMISSION_POWER[Start_Position] = Command_Received[Temp_Pos];
        DEBUG_UART2.printf("%s",SET_TRANSMISSION_POWER);
        Change_Beacon_Parameter(SET_TRANSMISSION_POWER);
    }
    else if((Command_Received[0] == SET_PAIRING_PASSWORD_CMD0) && (Command_Received[1] == SET_PAIRING_PASSWORD_CMD1))  //Check if command is received for Changing Pairing Password
    {
        Data_Length = 8;
        End_Position = (Start_Position + Data_Length);
        for(;Start_Position < End_Position;Start_Position++)
            SET_PAIRING_PASSWORD[Start_Position] = Command_Received[Temp_Pos++];
        DEBUG_UART2.printf("%s",SET_PAIRING_PASSWORD);
        //Change_Beacon_Parameter(SET_PAIRING_PASSWORD);
        Data_Length = 8;
        Start_Position = 4;
        End_Position = (Start_Position + Data_Length);
        //for(Start_Position;Start_Position < End_Position;Start_Position++)
        //  SET_SOFT_REBOOT[Start_Position] = Command_Received[Temp_Pos++]; //write code to update this password in eeprom  
        DEBUG_UART2.printf("%s",SOFT_REBOOT);
    }
    else if((Command_Received[0] == SET_BROADCAST_INTERVAL_CMD0) && (Command_Received[1] == SET_BROADCAST_INTERVAL_CMD1))  //Check if command is received for setting BroadCast Interval
    {
        SET_BROADCAST_INTERVAL[Start_Position] = Command_Received[Temp_Pos];
        DEBUG_UART2.printf("%s",SET_BROADCAST_INTERVAL);
        Change_Beacon_Parameter(SET_BROADCAST_INTERVAL);
    }
    else if((Command_Received[0] == SET_IBEACON_NAME_CMD0) && (Command_Received[1] == SET_IBEACON_NAME_CMD1))  //Check if command is received for setting ibeacon name
    {
        Data_Length = 12;
        End_Position = (Start_Position + Data_Length);
        for(;Start_Position < End_Position;Start_Position++)
            SET_IBEACON_NAME[Start_Position] = Command_Received[Temp_Pos++];
        DEBUG_UART2.printf("%s",SET_IBEACON_NAME);
        Change_Beacon_Parameter(SET_IBEACON_NAME);
    }
    else if((Command_Received[0] == SET_START_BEACON_CMD0) && (Command_Received[1] == SET_START_BEACON_CMD0))  //check if command is receievd for starting Beacon
    {
        DEBUG_UART2.printf("%s",SET_OPEN_BEACON);
        Change_Beacon_Parameter(SET_OPEN_BEACON);
    }   
    else if((Command_Received[0] == SET_STOP_BEACON_CMD0) && (Command_Received[1] == SET_STOP_BEACON_CMD1))  //Check if command is received for Stopping beacon and go to sleep mode
    {
        DEBUG_UART2.printf("%s",SET_CLOSE_BEACON);
        Change_Beacon_Parameter(SET_CLOSE_BEACON);
    }   
    else if((Command_Received[0] == SET_SOFT_REBOOT_CMD0) && (Command_Received[1] == SET_SOFT_REBOOT_CMD1))  //Check if command is received for Stopping beacon and go to sleep mode
    {
        Beacon_Module_UART.printf("%s",SOFT_REBOOT2);     //Soft Reboot Beacon Module
         DEBUG_UART2.printf("Beacon Device Resetted %s",SOFT_REBOOT2);
    }
}  
    
void Change_Beacon_Parameter(unsigned char* Beacon_Parameter_To_Set)
{
    uint8 i;
    for(i = 0;i<21;i++)
    {
        Beacon_Module_UART.putc(Beacon_Parameter_To_Set[i]);    
        DEBUG_UART2.putc(Beacon_Parameter_To_Set[i]);    
    }
    //Beacon_Module_UART.printf('%x',0x0d);    
    //DEBUG_UART2.putc('%x',0x0d);        
    Beacon_Module_UART.printf("%s",Beacon_Parameter_To_Set);    
    //Beacon_Module_UART.printf("%s",SOFT_REBOOT);     //Every Ibeacon command must be followed by Soft reset command in order to make the changes take place instantly
     //DEBUG_UART2.printf("%s",Beacon_Parameter_To_Set);
}

void Initialize_Beacon_Module(void)
{
    Beacon_Module_UART.baud(9600);  //set Beacon transmitter uart baud rate to default 9600
    //Read_Beacon_Module_MAC_ID();
}

void Read_Beacon_Module_MAC_ID(void)
{
    uint8 pos;
    Beacon_Module_UART.printf("%s",READ_BEACON_MAC_ID); 
    Get_Beacon_Response();
    for(pos=0;pos<6;pos++)
        BLE_Adv_Module_Beacon_ID[pos] = Beacon_RX_Buffer[pos];
}

void Get_Beacon_Response(void)
{
    char Beacon_inChar=0;
    //Keep reading characters until we get a carriage return
    while(Beacon_inChar != '\n')
    {
        //If a character comes in on the serial port, we need to act on it.
        if(Beacon_Module_UART.readable())
        {
            //Get the new character from the Serial port.
            Beacon_inChar = Beacon_Module_UART.getc();
            //Start by checking if we've received the end of message character ('\r').
            if(Beacon_inChar == '\n')
            {
                //Put the end of string character on our data string
                Beacon_RX_Buffer[Beacon_RxIndex]='\0';
                //Reset the buffer index so that the next character go    es back at the beginning of the string.
                Beacon_RxIndex=0;
            }
            //If we didn't get the end of message character, just add the new character to the string.
            else
            {
                //Add the new character to the string, and increment the index variable.
                Beacon_RX_Buffer[Beacon_RxIndex++]=Beacon_inChar;
            }
        }
    }
}
