#include "mbed.h"
#include "HTTPClient.h"
#include "TextLCD.h"

TextLCD lcd(p24,p26,p27,p28,p29,p30); // rs, e, d4-d7

#define PAGE_SIZE 77

HTTPClient http;

int main(void) {
    char result[PAGE_SIZE+1];
    char buf[40];
    char *e;

    time_t seconds;

    http.get("http://ntp-a1.nict.go.jp/cgi-bin/ntp", result,PAGE_SIZE);
    result[PAGE_SIZE]='\0';

    
    int start_body=strstr(result,"<BODY>")-result+7;
    int end_body = strstr(result,"</BODY>")-result-1;
    strncpy(buf, result+start_body, end_body-start_body);
    buf[end_body-start_body]='\0';
    
    seconds = strtoul(buf,&e,10)-2208988800UL;
    seconds += 32400;//JST TIME
    set_time(seconds);

    // Work is done!
    while (1) {
        seconds = time(NULL);
        strftime(buf,sizeof(buf),"%Y/%m/%d %a\n%H:%M:%S", localtime(&seconds));
        lcd.printf("%s\n", buf);
         wait(1);
    }
}

