#include "AE_KXSD9.h"

//constructor
AE_KXSD9::AE_KXSD9(PinName sda, PinName scl, int addr1, int addr2)
    :i2c_k(sda, scl),
     addr_w(addr1),
     addr_r(addr2)
{};


//destructor
/*
AE_KXSD9::~AE_KXSD9()
{
    
}
*/

//initialization(default setting)
void AE_KXSD9::init()
{
    char cmd_c=0xE1;//Reset Value
    char cmd_b=0x40;//Reset Value
    i2c_k.write(CTRL_REGC, &cmd_c, 1);
    i2c_k.write(CTRL_REGB, &cmd_b, 1);
}

//read each axial acceleration(unit:g)
void AE_KXSD9::read_xyz(double *x, double *y, double *z)
{
    const char addr_x_h = XOUT_H;
    char data[6] = {};
    short int acc[3]={};
    i2c_k.write(addr_w, &addr_x_h, 1);
    wait_us(500);
    i2c_k.read(addr_r, data, 6);
    for(int i=0;i<6;i+=2)acc[i/2]=((short int)data[i] << 4) + (short int)data[i+1] - 2048;
    
    *x = ((double)acc[0])/SENSITIVITY;
    *y = ((double)acc[1])/SENSITIVITY;
    *z = ((double)acc[2])/SENSITIVITY; 
}


//read the acceleration in x-axis(unit:g)
double AE_KXSD9::read_x()
{
    const char addr_x_h = XOUT_H;
    char data[2] = {};
    short int acc;
    i2c_k.write(addr_w, &addr_x_h, 1); 
    wait_us(500);
    i2c_k.read(addr_r, data, 2);
    acc=((short int)data[0] << 4) + (short int)data[1] - 2048;
    return (double)acc/SENSITIVITY;  
}


//read the acceleration in y-axis(unit:g)
double AE_KXSD9::read_y()
{
    const char addr_y_h = YOUT_H;
    char data[2] = {};
    short int acc;
    i2c_k.write(addr_w, &addr_y_h, 1);
    wait_us(500);
    i2c_k.read(addr_r, data, 2);
    acc=((short int)data[0] << 4) + (short int)data[1] - 2048;
    return (double)acc/SENSITIVITY;  
}


//read the acceleration in z-axis(unit:g)
double AE_KXSD9::read_z()
{

    const char addr_z_h = ZOUT_H;
    char data[2] = {0,0};
    short int acc;
    i2c_k.write(addr_w, &addr_z_h, 1);
    wait_us(500);
    i2c_k.read(addr_r, data, 2);
    acc=((short int)data[0] << 4) + (short int)data[1] - 2048;
    return (double)acc/SENSITIVITY;  
}

/*
//read from AE_KXSD9 register
char AE_KXSD9::read_reg(char addr)
{
    
}
*/

//write register
/*
void AE_KXSD9::write_reg(char addr, char data)
{
               
}
*/