#include "main.h"

/* VL53L0X */
I2C i2c(D4, D5);
VL53L0X vl_sensors[2] = {(&i2c),(&i2c)};
BusOut vl_shutdown(D12,D13);

/* PC */
Serial pc(USBTX, USBRX, 9600);
Serial ihm(PA_9, PA_10, 9600);

int main(void)
{
    pc.printf("23-03-21_Sensors_and_serial\n\r");

    /* Init VL53L0X */
    uint8_t expander_shutdown_mask = 1;

    for(uint8_t i = 0; i < 2 ; i++) {
        vl_shutdown = expander_shutdown_mask;
        expander_shutdown_mask = (expander_shutdown_mask << 1) + 1;
        vl_sensors[i].init();
        vl_sensors[i].setDeviceAddress(0x40 + i);
        vl_sensors[i].setModeContinuous();
        vl_sensors[i].startContinuous();
    }

    //uint16_t results[2];
    float results[2] = {0};

    /* Init AX-12 */
    AX12 myax12(PA_2, PA_3, 2, 250000); // ID = 2 pour le prototype de Lidar

    while(1) {
        for(float k = AX12_POS_MIN; k <= AX12_POS_MAX; k=k+AX12_POS_JUMP) {
            for(int i = 0; i < 2 ; i++) {
                //wait(AX12_TIME_JUMP);
                results[i] = (float)vl_sensors[i].getRangeMillimeters();
            }
            
            myax12.SetGoal(k);    // go to 0 degrees
            //pc.printf("k: %f 1: %fmm 2: %fmm \n\r", k, results[0], results[1]);
            ihm.printf("%f %f %f\n",k,results[0],results[1]);
            wait(AX12_TIME_JUMP);
        }

        for(float k = AX12_POS_MAX; k >= AX12_POS_MIN; k=k-AX12_POS_JUMP) {
            for(int i = 0; i < 2 ; i++) {
                //wait(AX12_TIME_JUMP);
                results[i] = (float)vl_sensors[i].getRangeMillimeters();
            }
            
            myax12.SetGoal(k);    // go to 0 degrees
            //pc.printf("k: %f 1: %fmm 2: %fmm \n\r", k, results[0], results[1]);
            ihm.printf("%f %f %f\n",k,results[0],results[1]);
            wait(AX12_TIME_JUMP);
        }
    }
}


